/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.CdcSchema;
import org.apache.paimon.flink.sink.cdc.EventParser;
import org.apache.paimon.flink.sink.cdc.RichCdcRecord;
import org.apache.paimon.types.DataField;

public class RichEventParser
implements EventParser<RichCdcRecord> {
    private RichCdcRecord record;
    private final LinkedHashMap<String, DataField> previousDataFields = new LinkedHashMap();
    private String previousComment;

    @Override
    public void setRawEvent(RichCdcRecord rawEvent) {
        this.record = rawEvent;
    }

    @Override
    public CdcSchema parseSchemaChange() {
        CdcSchema.Builder change = CdcSchema.newBuilder();
        CdcSchema recordedSchema = this.record.cdcSchema();
        recordedSchema.fields().forEach(dataField -> {
            DataField previous = this.previousDataFields.get(dataField.name());
            if (!DataField.dataFieldEqualsIgnoreId(previous, dataField)) {
                this.previousDataFields.put(dataField.name(), (DataField)dataField);
                change.column((DataField)dataField);
            }
        });
        if (recordedSchema.comment() != null && !recordedSchema.comment().equals(this.previousComment)) {
            this.previousComment = recordedSchema.comment();
            change.comment(recordedSchema.comment());
        }
        return change.build();
    }

    @Override
    public List<CdcRecord> parseRecords() {
        if (this.record.hasPayload()) {
            return Collections.singletonList(this.record.toCdcRecord());
        }
        return Collections.emptyList();
    }
}

