/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ssl.SSLException;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableSet;
import org.apache.paimon.shade.okhttp3.Interceptor;
import org.apache.paimon.shade.okhttp3.Request;
import org.apache.paimon.shade.okhttp3.Response;

public class ExponentialHttpRetryInterceptor
implements Interceptor {
    private final int maxRetries;
    private final Set<Class<? extends IOException>> nonRetriableExceptions;
    private final Set<Integer> retrievableCodes;
    private final Set<String> retrievableMethods;

    public ExponentialHttpRetryInterceptor(int maxRetries) {
        this.maxRetries = maxRetries;
        this.retrievableMethods = ImmutableSet.of("GET", "HEAD", "PUT", "DELETE", "TRACE", "OPTIONS", new String[0]);
        this.retrievableCodes = ImmutableSet.of(Integer.valueOf(429), Integer.valueOf(502), Integer.valueOf(503), Integer.valueOf(504));
        this.nonRetriableExceptions = ImmutableSet.of(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, NoRouteToHostException.class, SSLException.class);
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = null;
        int retryCount = 1;
        while (true) {
            block7: {
                block6: {
                    try {
                        response = chain.proceed(request);
                    }
                    catch (IOException e) {
                        if (!this.needRetry(request.method(), e, retryCount)) break block6;
                        this.wait(response, retryCount);
                        break block7;
                    }
                }
                if (this.needRetry(response, retryCount)) {
                    if (response != null) {
                        response.close();
                    }
                    this.wait(response, retryCount);
                } else {
                    return response;
                }
            }
            ++retryCount;
        }
    }

    public boolean needRetry(Response response, int execCount) {
        if (execCount > this.maxRetries) {
            return false;
        }
        return response == null || !response.isSuccessful() && this.retrievableCodes.contains(response.code());
    }

    public boolean needRetry(String method, IOException e, int execCount) throws IOException {
        if (execCount > this.maxRetries) {
            throw e;
        }
        if (!this.retrievableMethods.contains(method)) {
            throw e;
        }
        if (this.nonRetriableExceptions.contains(e.getClass())) {
            throw e;
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableExceptions) {
            if (!rejectException.isInstance(e)) continue;
            throw e;
        }
        return true;
    }

    public long getRetryIntervalInMilliseconds(Response response, int execCount) {
        String retryAfterStrInSecond = response == null ? null : response.header("Retry-After");
        Long retryAfter = null;
        if (retryAfterStrInSecond != null) {
            try {
                retryAfter = Long.parseLong(retryAfterStrInSecond) * 1000L;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (retryAfter != null && retryAfter > 0L) {
                return retryAfter;
            }
        }
        int delayMillis = 1000 * (int)Math.min(Math.pow(2.0, (double)execCount - 1.0), 64.0);
        int jitter = ThreadLocalRandom.current().nextInt(Math.max(1, (int)((double)delayMillis * 0.1)));
        return delayMillis + jitter;
    }

    private void wait(Response response, int retryCount) throws InterruptedIOException {
        try {
            Thread.sleep(this.getRetryIntervalInMilliseconds(response, retryCount));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }
}

