/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.append.cluster;

import java.util.List;
import java.util.Optional;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.compact.CompactUnit;
import org.apache.paimon.mergetree.LevelSortedRun;
import org.apache.paimon.mergetree.compact.UniversalCompaction;
import org.apache.paimon.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalClusterStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalClusterStrategy.class);
    private final List<String> clusterKeys;
    private final SchemaManager schemaManager;
    private final UniversalCompaction universalCompaction;

    public IncrementalClusterStrategy(SchemaManager schemaManager, List<String> clusterKeys, int maxSizeAmp, int sizeRatio, int numRunCompactionTrigger) {
        this.universalCompaction = new UniversalCompaction(maxSizeAmp, sizeRatio, numRunCompactionTrigger, null, null);
        this.clusterKeys = clusterKeys;
        this.schemaManager = schemaManager;
    }

    public Optional<CompactUnit> pick(int numLevels, List<LevelSortedRun> runs, boolean fullCompaction) {
        if (fullCompaction) {
            return this.pickFullCompaction(numLevels, runs);
        }
        return this.universalCompaction.pick(numLevels, runs);
    }

    public Optional<CompactUnit> pickFullCompaction(int numLevels, List<LevelSortedRun> runs) {
        long schemaId;
        CoreOptions coreOptions;
        int maxLevel = numLevels - 1;
        if (runs.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("no sorted run, no need to compact");
            }
            return Optional.empty();
        }
        if (runs.size() == 1 && runs.get(0).level() == maxLevel && (coreOptions = CoreOptions.fromMap(this.schemaManager.schema(schemaId = runs.get(0).run().files().get(0).schemaId()).options())).clusteringColumns().equals(this.clusterKeys)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("only one sorted run in the maxLevel with the same cluster key, no need to compact");
            }
            return Optional.empty();
        }
        return Optional.of(CompactUnit.fromLevelRuns(maxLevel, runs));
    }
}

