/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compact;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.deletionvectors.BucketedDvMaintainer;
import org.apache.paimon.deletionvectors.DeletionVectorsIndexFile;
import org.apache.paimon.index.IndexFileMeta;

public interface CompactDeletionFile {
    public Optional<IndexFileMeta> getOrCompute();

    public CompactDeletionFile mergeOldFile(CompactDeletionFile var1);

    public void clean();

    public static CompactDeletionFile generateFiles(BucketedDvMaintainer maintainer) {
        Optional<IndexFileMeta> file = maintainer.writeDeletionVectorsIndex();
        return new GeneratedDeletionFile(file.orElse(null), maintainer.dvIndexFile());
    }

    public static CompactDeletionFile lazyGeneration(BucketedDvMaintainer maintainer) {
        return new LazyCompactDeletionFile(maintainer);
    }

    public static class LazyCompactDeletionFile
    implements CompactDeletionFile {
        private final BucketedDvMaintainer maintainer;
        private boolean generated = false;

        public LazyCompactDeletionFile(BucketedDvMaintainer maintainer) {
            this.maintainer = maintainer;
        }

        @Override
        public Optional<IndexFileMeta> getOrCompute() {
            this.generated = true;
            return CompactDeletionFile.generateFiles(this.maintainer).getOrCompute();
        }

        @Override
        public CompactDeletionFile mergeOldFile(CompactDeletionFile old) {
            if (!(old instanceof LazyCompactDeletionFile)) {
                throw new IllegalStateException("old should be a LazyCompactDeletionFile, but it is: " + old.getClass());
            }
            if (((LazyCompactDeletionFile)old).generated) {
                throw new IllegalStateException("old should not be generated, this is a bug.");
            }
            return this;
        }

        @Override
        public void clean() {
        }
    }

    public static class GeneratedDeletionFile
    implements CompactDeletionFile {
        @Nullable
        private final IndexFileMeta deletionFile;
        private final DeletionVectorsIndexFile dvIndexFile;
        private boolean getInvoked = false;

        public GeneratedDeletionFile(@Nullable IndexFileMeta deletionFile, DeletionVectorsIndexFile dvIndexFile) {
            this.deletionFile = deletionFile;
            this.dvIndexFile = dvIndexFile;
        }

        @Override
        public Optional<IndexFileMeta> getOrCompute() {
            this.getInvoked = true;
            return Optional.ofNullable(this.deletionFile);
        }

        @Override
        public CompactDeletionFile mergeOldFile(CompactDeletionFile old) {
            if (!(old instanceof GeneratedDeletionFile)) {
                throw new IllegalStateException("old should be a GeneratedDeletionFile, but it is: " + old.getClass());
            }
            if (((GeneratedDeletionFile)old).getInvoked) {
                throw new IllegalStateException("old should not be get, this is a bug.");
            }
            if (this.deletionFile == null) {
                return old;
            }
            old.clean();
            return this;
        }

        @Override
        public void clean() {
            if (this.deletionFile != null) {
                this.dvIndexFile.delete(this.deletionFile);
            }
        }
    }
}

