/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.RandomAccessInputView;
import org.apache.paimon.data.SimpleCollectingOutputView;
import org.apache.paimon.data.serializer.AbstractRowDataSerializer;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.disk.RowBuffer;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.MutableObjectIterator;

public class InMemoryBuffer
implements RowBuffer {
    private static final EmptyInMemoryBufferIterator EMPTY_ITERATOR = new EmptyInMemoryBufferIterator();
    private final AbstractRowDataSerializer<InternalRow> serializer;
    private final ArrayList<MemorySegment> recordBufferSegments;
    private final SimpleCollectingOutputView recordCollector;
    private final MemorySegmentPool pool;
    private final int segmentSize;
    private long currentDataBufferOffset;
    private int numBytesInLastBuffer;
    private int numRecords = 0;
    private boolean isInitialized;

    public InMemoryBuffer(MemorySegmentPool pool, AbstractRowDataSerializer<InternalRow> serializer) {
        this.serializer = (AbstractRowDataSerializer)serializer.duplicate();
        this.pool = pool;
        this.segmentSize = pool.pageSize();
        this.recordBufferSegments = new ArrayList();
        this.recordCollector = new SimpleCollectingOutputView(this.recordBufferSegments, pool, this.segmentSize);
        this.isInitialized = true;
    }

    private void tryInitialize() {
        if (!this.isInitialized) {
            this.recordCollector.reset();
            this.isInitialized = true;
        }
    }

    @Override
    public void reset() {
        if (this.isInitialized) {
            this.currentDataBufferOffset = 0L;
            this.numBytesInLastBuffer = 0;
            this.numRecords = 0;
            this.returnToSegmentPool();
            this.isInitialized = false;
        }
    }

    @Override
    public boolean flushMemory() throws IOException {
        return false;
    }

    private void returnToSegmentPool() {
        this.pool.returnAll(this.recordBufferSegments);
        this.recordBufferSegments.clear();
    }

    @Override
    public boolean put(InternalRow row) throws IOException {
        try {
            this.tryInitialize();
            this.serializer.serializeToPages(row, this.recordCollector);
            this.currentDataBufferOffset = this.recordCollector.getCurrentOffset();
            this.numBytesInLastBuffer = this.recordCollector.getCurrentPositionInSegment();
            ++this.numRecords;
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    @Override
    public int size() {
        return this.numRecords;
    }

    @Override
    public long memoryOccupancy() {
        return this.currentDataBufferOffset;
    }

    @Override
    public InMemoryBufferIterator newIterator() {
        if (!this.isInitialized) {
            return EMPTY_ITERATOR;
        }
        RandomAccessInputView recordBuffer = new RandomAccessInputView(this.recordBufferSegments, this.segmentSize, this.numBytesInLastBuffer);
        return new InMemoryBufferIterator(recordBuffer, this.serializer);
    }

    ArrayList<MemorySegment> getRecordBufferSegments() {
        return this.recordBufferSegments;
    }

    long getCurrentDataBufferOffset() {
        return this.currentDataBufferOffset;
    }

    int getNumRecordBuffers() {
        if (!this.isInitialized) {
            return 0;
        }
        int result = (int)(this.currentDataBufferOffset / (long)this.segmentSize);
        long mod = this.currentDataBufferOffset % (long)this.segmentSize;
        if (mod != 0L) {
            ++result;
        }
        return result;
    }

    int getNumBytesInLastBuffer() {
        return this.numBytesInLastBuffer;
    }

    AbstractRowDataSerializer<InternalRow> getSerializer() {
        return this.serializer;
    }

    private static class EmptyInMemoryBufferIterator
    extends InMemoryBufferIterator {
        private EmptyInMemoryBufferIterator() {
            super(null, new InternalRowSerializer(new DataType[0]));
        }

        @Override
        public boolean advanceNext() {
            return false;
        }

        @Override
        public BinaryRow getRow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BinaryRow next(BinaryRow reuse) {
            return null;
        }

        @Override
        public BinaryRow next() {
            return null;
        }
    }

    private static class InMemoryBufferIterator
    implements RowBuffer.RowBufferIterator,
    MutableObjectIterator<BinaryRow> {
        private final RandomAccessInputView recordBuffer;
        private final AbstractRowDataSerializer<InternalRow> serializer;
        private final BinaryRow reuse;
        private BinaryRow row;

        private InMemoryBufferIterator(RandomAccessInputView recordBuffer, AbstractRowDataSerializer<InternalRow> serializer) {
            this.recordBuffer = recordBuffer;
            this.serializer = serializer;
            this.reuse = new BinaryRow(serializer.getArity());
        }

        @Override
        public boolean advanceNext() {
            try {
                this.row = this.next(this.reuse);
                return this.row != null;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        public BinaryRow getRow() {
            return this.row;
        }

        @Override
        public BinaryRow next(BinaryRow reuse) throws IOException {
            try {
                return (BinaryRow)this.serializer.mapFromPages(reuse, this.recordBuffer);
            }
            catch (EOFException e) {
                return null;
            }
        }

        @Override
        public BinaryRow next() throws IOException {
            return this.next(this.reuse);
        }

        @Override
        public void close() {
        }
    }
}

