/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.math.BigDecimal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.variant.BinaryVariant;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.flink.FlinkRowWrapper;
import org.apache.paimon.types.RowKind;

public class FlinkRowData
implements RowData {
    private InternalRow row;

    public FlinkRowData(InternalRow row) {
        this.row = row;
    }

    public FlinkRowData replace(InternalRow row) {
        this.row = row;
        return this;
    }

    @Override
    public int getArity() {
        return this.row.getFieldCount();
    }

    @Override
    public org.apache.flink.types.RowKind getRowKind() {
        return FlinkRowData.toFlinkRowKind(this.row.getRowKind());
    }

    @Override
    public void setRowKind(org.apache.flink.types.RowKind kind) {
        this.row.setRowKind(FlinkRowWrapper.fromFlinkRowKind(kind));
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.row.isNullAt(pos);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.row.getBoolean(pos);
    }

    @Override
    public byte getByte(int pos) {
        return this.row.getByte(pos);
    }

    @Override
    public short getShort(int pos) {
        return this.row.getShort(pos);
    }

    @Override
    public int getInt(int pos) {
        return this.row.getInt(pos);
    }

    @Override
    public long getLong(int pos) {
        return this.row.getLong(pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.row.getFloat(pos);
    }

    @Override
    public double getDouble(int pos) {
        return this.row.getDouble(pos);
    }

    @Override
    public StringData getString(int pos) {
        return FlinkRowData.toFlinkString(this.row.getString(pos));
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        return FlinkRowData.toFlinkDecimal(this.row.getDecimal(pos, precision, scale));
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        return FlinkRowData.toFlinkTimestamp(this.row.getTimestamp(pos, precision));
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.row.getBinary(pos);
    }

    @Override
    public ArrayData getArray(int pos) {
        return new FlinkArrayData(this.row.getArray(pos));
    }

    @Override
    public MapData getMap(int pos) {
        return new FlinkMapData(this.row.getMap(pos));
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        return new FlinkRowData(this.row.getRow(pos, numFields));
    }

    @Override
    public org.apache.flink.types.variant.Variant getVariant(int pos) {
        Variant variant = this.row.getVariant(pos);
        return new BinaryVariant(variant.value(), variant.metadata());
    }

    public static StringData toFlinkString(BinaryString str) {
        return StringData.fromBytes((byte[])str.toBytes());
    }

    public static TimestampData toFlinkTimestamp(Timestamp timestamp) {
        return TimestampData.fromEpochMillis((long)timestamp.getMillisecond(), (int)timestamp.getNanoOfMillisecond());
    }

    public static DecimalData toFlinkDecimal(Decimal decimal) {
        if (decimal.isCompact()) {
            return DecimalData.fromUnscaledLong((long)decimal.toUnscaledLong(), (int)decimal.precision(), (int)decimal.scale());
        }
        return DecimalData.fromBigDecimal((BigDecimal)decimal.toBigDecimal(), (int)decimal.precision(), (int)decimal.scale());
    }

    public static org.apache.flink.types.RowKind toFlinkRowKind(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: {
                return org.apache.flink.types.RowKind.INSERT;
            }
            case UPDATE_BEFORE: {
                return org.apache.flink.types.RowKind.UPDATE_BEFORE;
            }
            case UPDATE_AFTER: {
                return org.apache.flink.types.RowKind.UPDATE_AFTER;
            }
            case DELETE: {
                return org.apache.flink.types.RowKind.DELETE;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static class FlinkMapData
    implements MapData {
        private final InternalMap map;

        private FlinkMapData(InternalMap map) {
            this.map = map;
        }

        public int size() {
            return this.map.size();
        }

        public ArrayData keyArray() {
            return new FlinkArrayData(this.map.keyArray());
        }

        public ArrayData valueArray() {
            return new FlinkArrayData(this.map.valueArray());
        }
    }

    private static class FlinkArrayData
    implements ArrayData {
        private final InternalArray array;

        private FlinkArrayData(InternalArray array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.size();
        }

        @Override
        public boolean isNullAt(int pos) {
            return this.array.isNullAt(pos);
        }

        @Override
        public boolean getBoolean(int pos) {
            return this.array.getBoolean(pos);
        }

        @Override
        public byte getByte(int pos) {
            return this.array.getByte(pos);
        }

        @Override
        public short getShort(int pos) {
            return this.array.getShort(pos);
        }

        @Override
        public int getInt(int pos) {
            return this.array.getInt(pos);
        }

        @Override
        public long getLong(int pos) {
            return this.array.getLong(pos);
        }

        @Override
        public float getFloat(int pos) {
            return this.array.getFloat(pos);
        }

        @Override
        public double getDouble(int pos) {
            return this.array.getDouble(pos);
        }

        @Override
        public StringData getString(int pos) {
            return FlinkRowData.toFlinkString(this.array.getString(pos));
        }

        @Override
        public DecimalData getDecimal(int pos, int precision, int scale) {
            return FlinkRowData.toFlinkDecimal(this.array.getDecimal(pos, precision, scale));
        }

        @Override
        public TimestampData getTimestamp(int pos, int precision) {
            return FlinkRowData.toFlinkTimestamp(this.array.getTimestamp(pos, precision));
        }

        @Override
        public <T> RawValueData<T> getRawValue(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public org.apache.flink.types.variant.Variant getVariant(int pos) {
            Variant variant = this.array.getVariant(pos);
            return new BinaryVariant(variant.value(), variant.metadata());
        }

        @Override
        public byte[] getBinary(int pos) {
            return this.array.getBinary(pos);
        }

        @Override
        public ArrayData getArray(int pos) {
            return new FlinkArrayData(this.array.getArray(pos));
        }

        @Override
        public MapData getMap(int pos) {
            return new FlinkMapData(this.array.getMap(pos));
        }

        @Override
        public RowData getRow(int pos, int numFields) {
            return new FlinkRowData(this.array.getRow(pos, numFields));
        }

        @Override
        public boolean[] toBooleanArray() {
            return this.array.toBooleanArray();
        }

        @Override
        public byte[] toByteArray() {
            return this.array.toByteArray();
        }

        @Override
        public short[] toShortArray() {
            return this.array.toShortArray();
        }

        @Override
        public int[] toIntArray() {
            return this.array.toIntArray();
        }

        @Override
        public long[] toLongArray() {
            return this.array.toLongArray();
        }

        @Override
        public float[] toFloatArray() {
            return this.array.toFloatArray();
        }

        @Override
        public double[] toDoubleArray() {
            return this.array.toDoubleArray();
        }
    }
}

