/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.factories.Factory;
import org.apache.paimon.factories.FactoryException;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ActionFactory
extends Factory {
    public static final Logger LOG = LoggerFactory.getLogger(ActionFactory.class);
    public static final String HELP = "help";
    public static final String WAREHOUSE = "warehouse";
    public static final String DATABASE = "database";
    public static final String TABLE = "table";
    @Deprecated
    public static final String PATH = "path";
    public static final String CATALOG_CONF = "catalog_conf";
    public static final String TABLE_CONF = "table_conf";
    public static final String PARTITION = "partition";
    public static final String EXPIRATIONTIME = "expiration_time";
    public static final String TIMESTAMPFORMATTER = "timestamp_formatter";
    public static final String EXPIRE_STRATEGY = "expire_strategy";
    public static final String TIMESTAMP_PATTERN = "timestamp_pattern";
    public static final String COMPACT_STRATEGY = "compact_strategy";
    public static final String MINOR = "minor";
    public static final String FULL = "full";

    public Optional<Action> create(MultipleParameterToolAdapter var1);

    public static Optional<Action> createAction(String[] args) {
        ActionFactory actionFactory;
        String action = args[0].toLowerCase().replaceAll("-", "_");
        CharSequence[] actionArgs = Arrays.copyOfRange(args, 1, args.length);
        try {
            actionFactory = FactoryUtil.discoverFactory(ActionFactory.class.getClassLoader(), ActionFactory.class, action);
        }
        catch (FactoryException e) {
            ActionFactory.printDefaultHelp();
            throw new UnsupportedOperationException("Unknown action \"" + action + "\".");
        }
        LOG.info("{} job args: {}", (Object)actionFactory.identifier(), (Object)String.join((CharSequence)" ", actionArgs));
        MultipleParameterToolAdapter params = new MultipleParameterToolAdapter((String[])actionArgs);
        if (params.has(HELP)) {
            actionFactory.printHelp();
            return Optional.empty();
        }
        if (params.has(PATH)) {
            throw new UnsupportedOperationException(String.format("Parameter '%s' is deprecated. Please use '--%s %s=<warehouse>' to specify warehouse if needed, and use '%s' to specify database and '%s' to specify table.", PATH, CATALOG_CONF, CatalogOptions.WAREHOUSE.key(), DATABASE, TABLE));
        }
        return actionFactory.create(params);
    }

    public void printHelp();

    public static void printDefaultHelp() {
        System.out.println("Usage: <action> [OPTIONS]");
        System.out.println();
        System.out.println("Available actions:");
        List<String> identifiers = FactoryUtil.discoverIdentifiers(ActionFactory.class.getClassLoader(), ActionFactory.class);
        identifiers.forEach(action -> System.out.println("  " + action));
        System.out.println("For detailed options of each action, run <action> --help");
    }

    default public List<Map<String, String>> getPartitions(MultipleParameterToolAdapter params) {
        ArrayList<Map<String, String>> partitions = new ArrayList<Map<String, String>>();
        for (String partition : params.getMultiParameter(PARTITION)) {
            Map<String, String> kvs = ParameterUtils.parseCommaSeparatedKeyValues(partition);
            partitions.add(kvs);
        }
        return partitions;
    }

    default public Map<String, String> optionalConfigMap(MultipleParameterToolAdapter params, String key) {
        if (!params.has(key)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> config = new HashMap<String, String>();
        for (String kvString : params.getMultiParameter(key)) {
            ParameterUtils.parseKeyValueString(config, kvString);
        }
        return config;
    }

    default public Map<String, List<String>> optionalConfigMapList(MultipleParameterToolAdapter params, String key) {
        if (!params.has(key)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> config = new HashMap<String, List<String>>();
        for (String kvString : params.getMultiParameter(key)) {
            ParameterUtils.parseKeyValueList(config, kvString);
        }
        return config;
    }

    default public Map<String, String> catalogConfigMap(MultipleParameterToolAdapter params) {
        HashMap<String, String> catalogConfig = new HashMap<String, String>(this.optionalConfigMap(params, CATALOG_CONF));
        String warehouse = params.get(WAREHOUSE);
        if (warehouse != null && !catalogConfig.containsKey(WAREHOUSE)) {
            catalogConfig.put(WAREHOUSE, warehouse);
        }
        return catalogConfig;
    }
}

