/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.DeleteAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class DeleteActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "delete";
    private static final String WHERE = "where";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        String filter = params.get(WHERE);
        if (filter == null) {
            throw new IllegalArgumentException("Please specify deletion filter. If you want to delete all records, please use overwrite (see doc).");
        }
        DeleteAction action = new DeleteAction(params.getRequired("database"), params.getRequired("table"), filter, this.catalogConfigMap(params));
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"delete\" deletes data from a table.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  delete \\\n --warehouse <warehouse_path> \\\n--database <database_name> \\\n--table <table_name> \\\n--where <filter_spec>");
        System.out.println("  delete --path <table_path> --where <filter_spec>");
        System.out.println();
        System.out.println("The '--where <filter_spec>' part is equal to the 'WHERE' clause in SQL DELETE statement. If you want to delete all records, please use overwrite (see doc).");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  delete --path hdfs:///path/to/warehouse/test_db.db/test_table --where 'id > (SELECT count(*) FROM employee)'");
        System.out.println("  It's equal to 'DELETE FROM test_table WHERE id > (SELECT count(*) FROM employee)");
    }
}

