/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql.format;

import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.document.DocumentReader;
import io.debezium.relational.Table;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.TableChanges;
import java.io.IOException;
import org.apache.flink.cdc.debezium.history.FlinkJsonTableChangeSerializer;

public class DebeziumEventUtils {
    private static final DocumentReader DOCUMENT_READER = DocumentReader.defaultReader();

    public static HistoryRecord getHistoryRecord(String historyRecordStr) throws IOException {
        return new HistoryRecord(DOCUMENT_READER.read(historyRecordStr));
    }

    public static TableChanges getTableChanges(String historyRecordStr) throws IOException {
        HistoryRecord historyRecord = DebeziumEventUtils.getHistoryRecord(historyRecordStr);
        Array tableChangesDocument = historyRecord.document().getArray((CharSequence)"tableChanges");
        return DebeziumEventUtils.deserialize(tableChangesDocument, true);
    }

    private static TableChanges deserialize(Array array, boolean useCatalogBeforeSchema) {
        TableChanges tableChanges = new TableChanges();
        for (Array.Entry entry : array) {
            Document document = entry.getValue().asDocument();
            TableChanges.TableChange change = FlinkJsonTableChangeSerializer.fromDocument((Document)document, (boolean)useCatalogBeforeSchema);
            if (change.getType() == TableChanges.TableChangeType.CREATE) {
                tableChanges.create(DebeziumEventUtils.supplementTableComment(document, change.getTable()));
                continue;
            }
            if (change.getType() == TableChanges.TableChangeType.ALTER) {
                tableChanges.alter(DebeziumEventUtils.supplementTableComment(document, change.getTable()));
                continue;
            }
            if (change.getType() != TableChanges.TableChangeType.DROP) continue;
            tableChanges.drop(change.getTable());
        }
        return tableChanges;
    }

    private static Table supplementTableComment(Document document, Table table) {
        if (table.comment() != null) {
            return table;
        }
        String comment = document.getString((CharSequence)"comment");
        if (comment != null) {
            return table.edit().setComment(comment).create();
        }
        return table;
    }
}

