/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.copy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.copy.CopyFileInfo;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.manifest.SimpleFileEntry;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.SupplierWithIOException;

public class CopyFilesUtil {
    private static final int READ_FILE_RETRY_NUM = 3;
    private static final int READ_FILE_RETRY_INTERVAL = 5;

    public static List<Path> getSchemaUsedFilesForSnapshot(FileStoreTable table, long snapshotId) throws IOException {
        FileStore<?> store = table.store();
        SnapshotManager snapshotManager = store.snapshotManager();
        Snapshot snapshot = snapshotManager.tryGetSnapshot(snapshotId);
        SchemaManager schemaManager = new SchemaManager(table.fileIO(), table.location());
        IndexFileHandler indexFileHandler = store.newIndexFileHandler();
        ArrayList<Path> fileList = new ArrayList<Path>();
        if (snapshot != null) {
            FileStorePathFactory pathFactory = store.pathFactory();
            fileList.add(snapshotManager.snapshotPath(snapshotId));
            CopyFilesUtil.addManifestList(fileList, snapshot, pathFactory);
            String indexManifest = snapshot.indexManifest();
            if (indexManifest != null && indexFileHandler.existsManifest(indexManifest)) {
                fileList.add(pathFactory.indexManifestFileFactory().toPath(indexManifest));
                List indexManifestEntries = CopyFilesUtil.retryReadingFiles(() -> indexFileHandler.readManifestWithIOException(indexManifest));
                if (indexManifestEntries != null) {
                    indexManifestEntries.stream().map(indexFileHandler::filePath).forEach(fileList::add);
                }
            }
            if (snapshot.statistics() != null) {
                fileList.add(pathFactory.statsFileFactory().toPath(snapshot.statistics()));
            }
        }
        for (long id : schemaManager.listAllIds()) {
            fileList.add(schemaManager.toSchemaPath(id));
        }
        return fileList;
    }

    public static List<Pair<Path, Path>> getDataUsedFilesForSnapshot(FileStoreTable table, long snapshotId) throws FileNotFoundException {
        FileStore<?> store = table.store();
        SnapshotManager snapshotManager = store.snapshotManager();
        Snapshot snapshot = snapshotManager.tryGetSnapshot(snapshotId);
        ArrayList<Pair<Path, Path>> fileList = new ArrayList<Pair<Path, Path>>();
        if (snapshot != null) {
            ArrayList<Pair<Path, Path>> dataFiles = new ArrayList<Pair<Path, Path>>();
            List<SimpleFileEntry> simpleFileEntries = store.newScan().withSnapshot(snapshot).readSimpleEntries();
            for (SimpleFileEntry simpleFileEntry : simpleFileEntries) {
                FileStorePathFactory fileStorePathFactory = store.pathFactory();
                Path dataFilePath = fileStorePathFactory.createDataFilePathFactory(simpleFileEntry.partition(), simpleFileEntry.bucket()).toPath(simpleFileEntry);
                Path relativeBucketPath = fileStorePathFactory.relativeBucketPath(simpleFileEntry.partition(), simpleFileEntry.bucket());
                Path relativeTablePath = new Path("/" + relativeBucketPath, dataFilePath.getName());
                dataFiles.add(Pair.of(dataFilePath, relativeTablePath));
            }
            Collections.reverse(dataFiles);
            fileList.addAll(dataFiles);
        }
        return fileList;
    }

    public static List<Path> getManifestUsedFilesForSnapshot(FileStoreTable table, long snapshotId) throws IOException {
        FileStore<?> store = table.store();
        SnapshotManager snapshotManager = store.snapshotManager();
        Snapshot snapshot = snapshotManager.tryGetSnapshot(snapshotId);
        ManifestList manifestList = store.manifestListFactory().create();
        ArrayList<Path> fileList = new ArrayList<Path>();
        List manifestFileMetas = CopyFilesUtil.retryReadingFiles(() -> CopyFilesUtil.readAllManifestsWithIOException(snapshot, manifestList));
        if (manifestFileMetas == null) {
            return fileList;
        }
        List manifestFileName = manifestFileMetas.stream().map(ManifestFileMeta::fileName).collect(Collectors.toList());
        fileList.addAll(manifestFileName.stream().map(store.pathFactory()::toManifestFilePath).collect(Collectors.toList()));
        return fileList;
    }

    private static void addManifestList(List<Path> fileList, Snapshot snapshot, FileStorePathFactory pathFactory) {
        fileList.add(pathFactory.toManifestListPath(snapshot.baseManifestList()));
        fileList.add(pathFactory.toManifestListPath(snapshot.deltaManifestList()));
        String changelogManifestList = snapshot.changelogManifestList();
        if (changelogManifestList != null) {
            fileList.add(pathFactory.toManifestListPath(changelogManifestList));
        }
    }

    private static List<ManifestFileMeta> readAllManifestsWithIOException(Snapshot snapshot, ManifestList manifestList) throws IOException {
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        result.addAll(manifestList.readWithIOException(snapshot.baseManifestList()));
        result.addAll(manifestList.readWithIOException(snapshot.deltaManifestList()));
        String changelogManifestList = snapshot.changelogManifestList();
        if (changelogManifestList != null) {
            result.addAll(manifestList.readWithIOException(changelogManifestList));
        }
        return result;
    }

    @Nullable
    public static <T> T retryReadingFiles(SupplierWithIOException<T> reader) throws IOException {
        int retryNumber = 0;
        IOException caught = null;
        while (retryNumber++ < 3) {
            try {
                return reader.get();
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                caught = e;
                try {
                    TimeUnit.MILLISECONDS.sleep(5L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e2);
                }
            }
        }
        throw caught;
    }

    public static List<CopyFileInfo> toCopyFileInfos(List<Path> fileList, Path sourceTableRoot, String sourceIdentifier, String targetIdentifier) {
        ArrayList<CopyFileInfo> result = new ArrayList<CopyFileInfo>();
        for (Path file : fileList) {
            Path relativePath = CopyFilesUtil.getPathExcludeTableRoot(file, sourceTableRoot);
            result.add(new CopyFileInfo(file.toUri().toString(), relativePath.toString(), sourceIdentifier, targetIdentifier));
        }
        return result;
    }

    public static Path getPathExcludeTableRoot(Path absolutePath, Path sourceTableRoot) {
        String fileAbsolutePath = absolutePath.toUri().toString();
        String sourceTableRootPath = sourceTableRoot.toString();
        Preconditions.checkState(fileAbsolutePath.startsWith(sourceTableRootPath), "File absolute path does not start with source table root path. This is unexpected. fileAbsolutePath is: " + fileAbsolutePath + ", sourceTableRootPath is: " + sourceTableRootPath);
        return new Path(fileAbsolutePath.substring(sourceTableRootPath.length()));
    }

    public static FileIO getFileIO(Map<String, FileIO> fileIOs, String identifier, Catalog catalog) {
        return fileIOs.computeIfAbsent(identifier, key -> {
            try {
                return ((FileStoreTable)catalog.getTable(Identifier.fromString(key))).fileIO();
            }
            catch (Catalog.TableNotExistException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static Path getPath(Map<String, Path> locations, String identifier, Catalog catalog) {
        return locations.computeIfAbsent(identifier, key -> {
            try {
                return CopyFilesUtil.pathOfTable(catalog.getTable(Identifier.fromString(key)));
            }
            catch (Catalog.TableNotExistException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static Path pathOfTable(Table table) {
        return new Path(table.options().get(CoreOptions.PATH.key()));
    }
}

