/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.lookup.DynamicPartitionLoader;
import org.apache.paimon.table.FileStoreTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPartitionNumberLoader
extends DynamicPartitionLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicPartitionNumberLoader.class);
    private static final long serialVersionUID = 1L;
    private final int maxPartitionNum;

    DynamicPartitionNumberLoader(FileStoreTable table, Duration refreshInterval, int maxPartitionNum) {
        super(table, refreshInterval);
        this.maxPartitionNum = maxPartitionNum;
        LOG.info("Init DynamicPartitionNumberLoader(table={}),maxPartitionNum is {}", (Object)table.name(), (Object)maxPartitionNum);
    }

    @Override
    protected List<BinaryRow> getMaxPartitions() {
        List<BinaryRow> newPartitions = this.table.newReadBuilder().newScan().listPartitions().stream().sorted(this.comparator.reversed()).collect(Collectors.toList());
        if (newPartitions.size() <= this.maxPartitionNum) {
            return newPartitions;
        }
        return newPartitions.subList(0, this.maxPartitionNum);
    }
}

