/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.flink.action.CloneAction;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.utils.StringUtils;

public class CloneProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "clone";

    @ProcedureHint(argument={@ArgumentHint(name="database", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="table", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="catalog_conf", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="target_database", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="target_table", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="target_catalog_conf", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="parallelism", type=@DataTypeHint(value="INT"), isOptional=true), @ArgumentHint(name="where", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="included_tables", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="excluded_tables", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="clone_from", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String database, String tableName, String sourceCatalogConfigStr, String targetDatabase, String targetTableName, String targetCatalogConfigStr, Integer parallelism, String where, String includedTablesStr, String excludedTablesStr, String cloneFrom) throws Exception {
        HashMap<String, String> sourceCatalogConfig = new HashMap<String, String>(this.optionalConfigMap(sourceCatalogConfigStr));
        HashMap<String, String> targetCatalogConfig = new HashMap<String, String>(this.optionalConfigMap(targetCatalogConfigStr));
        List<String> includedTables = StringUtils.isNullOrWhitespaceOnly(includedTablesStr) ? null : Arrays.asList(StringUtils.split(includedTablesStr, ","));
        List<String> excludedTables = StringUtils.isNullOrWhitespaceOnly(excludedTablesStr) ? null : Arrays.asList(StringUtils.split(excludedTablesStr, ","));
        CloneAction action = new CloneAction(database, tableName, sourceCatalogConfig, targetDatabase, targetTableName, targetCatalogConfig, parallelism, where, includedTables, excludedTables, cloneFrom);
        return this.execute(procedureContext, action, "Clone Job");
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

