/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.HashMap;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.utils.ProcedureUtils;

public class CompactManifestProcedure
extends ProcedureBase {
    private static final String COMMIT_USER = "Compact-Manifest-Procedure-Committer";

    @Override
    public String identifier() {
        return "compact_manifest";
    }

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="options", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, String options) throws Exception {
        Table table = (FileStoreTable)this.table(tableId);
        HashMap<String, String> dynamicOptions = new HashMap<String, String>();
        ProcedureUtils.putIfNotEmpty(dynamicOptions, CoreOptions.COMMIT_USER_PREFIX.key(), COMMIT_USER);
        ProcedureUtils.putAllOptions(dynamicOptions, options);
        table = table.copy(dynamicOptions);
        try (BatchTableCommit commit = table.newBatchWriteBuilder().newCommit();){
            commit.compactManifests();
        }
        return new String[]{"success"};
    }
}

