/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.flink.utils.TableMigrationUtils;
import org.apache.paimon.migrate.Migrator;
import org.apache.paimon.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateTableProcedure
extends ProcedureBase {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateTableProcedure.class);
    private static final String PAIMON_SUFFIX = "_paimon_";

    @Override
    public String identifier() {
        return "migrate_table";
    }

    @ProcedureHint(argument={@ArgumentHint(name="connector", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="source_table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="target_table", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="options", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="parallelism", type=@DataTypeHint(value="Integer"), isOptional=true), @ArgumentHint(name="delete_origin", type=@DataTypeHint(value="BOOLEAN"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String connector, String sourceTable, String targetTable, String properties, Integer parallelism, Boolean deleteOrigin) throws Exception {
        Identifier sourceTableId = Identifier.fromString(sourceTable);
        Identifier targetTableId = Identifier.fromString(targetTable == null ? sourceTable + PAIMON_SUFFIX : targetTable);
        Integer p = parallelism == null ? Runtime.getRuntime().availableProcessors() : parallelism.intValue();
        Migrator migrator = TableMigrationUtils.getImporter(connector, this.catalog, sourceTableId.getDatabaseName(), sourceTableId.getObjectName(), targetTableId.getDatabaseName(), targetTableId.getObjectName(), p, ParameterUtils.parseCommaSeparatedKeyValues(this.notnull(properties)));
        LOG.info("create migrator success.");
        if (deleteOrigin != null) {
            migrator.deleteOriginTable(deleteOrigin);
        }
        migrator.executeMigrate();
        if (targetTable == null) {
            migrator.renameTable(false);
        }
        return new String[]{"Success"};
    }
}

