/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.paimon.append.AppendCompactTask;
import org.apache.paimon.table.sink.AppendCompactTaskSerializer;

public class CompactionTaskSimpleSerializer
implements SimpleVersionedSerializer<AppendCompactTask> {
    private final AppendCompactTaskSerializer compactionTaskSerializer;

    public CompactionTaskSimpleSerializer(AppendCompactTaskSerializer compactionTaskSerializer) {
        this.compactionTaskSerializer = compactionTaskSerializer;
    }

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(AppendCompactTask compactionTask) throws IOException {
        byte[] wrapped = this.compactionTaskSerializer.serialize(compactionTask);
        int version = this.compactionTaskSerializer.getVersion();
        return ByteBuffer.allocate(wrapped.length + 4).put(wrapped).putInt(version).array();
    }

    public AppendCompactTask deserialize(int compactionTaskVersion, byte[] bytes) throws IOException {
        if (compactionTaskVersion != this.getVersion()) {
            throw new RuntimeException("Can not deserialize version: " + compactionTaskVersion);
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte[] wrapped = new byte[bytes.length - 4];
        buffer.get(wrapped);
        int version = buffer.getInt();
        return this.compactionTaskSerializer.deserialize(version, wrapped);
    }
}

