/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManagerImpl;
import org.apache.paimon.flink.metrics.FlinkMetricRegistry;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.flink.sink.StoreSinkWriteState;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.memory.MemoryPoolFactory;
import org.apache.paimon.operation.FileStoreWrite;
import org.apache.paimon.operation.WriteRestore;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.SinkRecord;
import org.apache.paimon.table.sink.TableWrite;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSinkWriteImpl
implements StoreSinkWrite {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSinkWriteImpl.class);
    protected final String commitUser;
    protected final StoreSinkWriteState state;
    private final IOManagerImpl paimonIOManager;
    private final boolean ignorePreviousFiles;
    private final boolean waitCompaction;
    private final boolean isStreamingMode;
    private final MemoryPoolFactory memoryPoolFactory;
    @Nullable
    private final MetricGroup metricGroup;
    protected TableWriteImpl<?> write;

    public StoreSinkWriteImpl(FileStoreTable table, String commitUser, StoreSinkWriteState state, IOManager ioManager, boolean ignorePreviousFiles, boolean waitCompaction, boolean isStreamingMode, MemoryPoolFactory memoryPoolFactory, @Nullable MetricGroup metricGroup) {
        this.commitUser = commitUser;
        this.state = state;
        this.paimonIOManager = new IOManagerImpl(ioManager.getSpillingDirectoriesPaths());
        this.ignorePreviousFiles = ignorePreviousFiles;
        this.waitCompaction = waitCompaction;
        this.isStreamingMode = isStreamingMode;
        this.memoryPoolFactory = memoryPoolFactory;
        this.metricGroup = metricGroup;
        this.write = this.newTableWrite(table);
    }

    private TableWriteImpl<?> newTableWrite(FileStoreTable table) {
        TableWrite tableWrite = ((TableWriteImpl)((TableWriteImpl)table.newWrite(this.commitUser, this.state.getSubtaskId()).withIOManager(this.paimonIOManager)).withIgnorePreviousFiles(this.ignorePreviousFiles)).withBucketMode(table.bucketMode()).withMemoryPoolFactory(this.memoryPoolFactory);
        if (this.metricGroup != null) {
            ((TableWriteImpl)tableWrite).withMetricRegistry(new FlinkMetricRegistry(this.metricGroup));
        }
        return tableWrite;
    }

    public void withCompactExecutor(ExecutorService compactExecutor) {
        this.write.withCompactExecutor(compactExecutor);
    }

    @Override
    public void setWriteRestore(WriteRestore writeRestore) {
        this.write.withWriteRestore(writeRestore);
    }

    @Override
    @Nullable
    public SinkRecord write(InternalRow rowData) throws Exception {
        return this.write.writeAndReturn(rowData);
    }

    @Override
    @Nullable
    public SinkRecord write(InternalRow rowData, int bucket) throws Exception {
        return this.write.writeAndReturn(rowData, bucket);
    }

    @Override
    public SinkRecord toLogRecord(SinkRecord record) {
        return this.write.toLogRecord(record);
    }

    @Override
    public void compact(BinaryRow partition, int bucket, boolean fullCompaction) throws Exception {
        this.write.compact(partition, bucket, fullCompaction);
    }

    @Override
    public void notifyNewFiles(long snapshotId, BinaryRow partition, int bucket, List<DataFileMeta> files) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Receive {} new files from snapshot {}, partition {}, bucket {}", new Object[]{files.size(), snapshotId, partition, bucket});
        }
        this.write.notifyNewFiles(snapshotId, partition, bucket, files);
    }

    @Override
    public List<Committable> prepareCommit(boolean waitCompaction, long checkpointId) throws IOException {
        ArrayList<Committable> committables = new ArrayList<Committable>();
        if (this.write != null) {
            try {
                for (CommitMessage committable : this.write.prepareCommit(this.waitCompaction || waitCompaction, checkpointId)) {
                    committables.add(new Committable(checkpointId, Committable.Kind.FILE, committable));
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return committables;
    }

    @Override
    public void snapshotState() throws Exception {
    }

    @Override
    public boolean streamingMode() {
        return this.isStreamingMode;
    }

    @Override
    public void close() throws Exception {
        if (this.write != null) {
            this.write.close();
        }
        this.paimonIOManager.close();
    }

    @Override
    public void replace(FileStoreTable newTable) throws Exception {
        if (this.commitUser == null) {
            return;
        }
        Object states = this.write.checkpoint();
        this.write.close();
        this.write = this.newTableWrite(newTable);
        this.write.restore((List<FileStoreWrite.State<?>>)states);
    }

    @VisibleForTesting
    public TableWriteImpl<?> getWrite() {
        return this.write;
    }
}

