/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.flink.sink.cdc.CdcDynamicBucketSinkBase;
import org.apache.paimon.flink.sink.cdc.CdcDynamicBucketWriteOperator;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.CdcRecordKeyAndBucketExtractor;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;

public class CdcDynamicBucketSink
extends CdcDynamicBucketSinkBase<CdcRecord> {
    private static final long serialVersionUID = 2L;

    public CdcDynamicBucketSink(FileStoreTable table) {
        super(table);
    }

    @Override
    protected KeyAndBucketExtractor<CdcRecord> createExtractor(TableSchema schema) {
        return new CdcRecordKeyAndBucketExtractor(schema);
    }

    @Override
    protected OneInputStreamOperatorFactory<Tuple2<CdcRecord, Integer>, Committable> createWriteOperatorFactory(StoreSinkWrite.Provider writeProvider, String commitUser) {
        Options options = this.table.coreOptions().toConfiguration();
        boolean coordinatorEnabled = options.get(FlinkConnectorOptions.SINK_WRITER_COORDINATOR_ENABLED);
        return coordinatorEnabled ? new CdcDynamicBucketWriteOperator.CoordinatedFactory(this.table, writeProvider, commitUser) : new CdcDynamicBucketWriteOperator.Factory(this.table, writeProvider, commitUser);
    }
}

