/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.bucket.BucketFunction;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.CdcRecordUtils;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;

public class CdcRecordKeyAndBucketExtractor
implements KeyAndBucketExtractor<CdcRecord> {
    private final int numBuckets;
    private final List<DataField> partitionFields;
    private final Projection partitionProjection;
    private final List<DataField> bucketKeyFields;
    private final Projection bucketKeyProjection;
    private final List<DataField> trimmedPKFields;
    private final Projection trimmedPKProjection;
    private final BucketFunction bucketFunction;
    private CdcRecord record;
    private BinaryRow partition;
    private BinaryRow trimmedPK;
    private BinaryRow bucketKey;
    private Integer bucket;

    public CdcRecordKeyAndBucketExtractor(TableSchema schema) {
        this.numBuckets = new CoreOptions(schema.options()).bucket();
        RowType partitionType = schema.logicalPartitionType();
        this.partitionFields = partitionType.getFields();
        this.partitionProjection = CodeGenUtils.newProjection(partitionType, IntStream.range(0, partitionType.getFieldCount()).toArray());
        RowType bucketKeyType = schema.logicalBucketKeyType();
        this.bucketKeyFields = bucketKeyType.getFields();
        this.bucketKeyProjection = CodeGenUtils.newProjection(bucketKeyType, IntStream.range(0, bucketKeyType.getFieldCount()).toArray());
        this.trimmedPKFields = schema.trimmedPrimaryKeysFields();
        this.trimmedPKProjection = CodeGenUtils.newProjection(new RowType(this.trimmedPKFields), IntStream.range(0, this.trimmedPKFields.size()).toArray());
        this.bucketFunction = BucketFunction.create(new CoreOptions(schema.options()), schema.logicalBucketKeyType());
    }

    @Override
    public void setRecord(CdcRecord record) {
        this.record = record;
        this.partition = null;
        this.bucketKey = null;
        this.trimmedPK = null;
        this.bucket = null;
    }

    @Override
    public BinaryRow partition() {
        if (this.partition == null) {
            this.partition = this.partitionProjection.apply(CdcRecordUtils.projectAsInsert(this.record, this.partitionFields));
        }
        return this.partition;
    }

    @Override
    public int bucket() {
        if (this.bucketKey == null) {
            this.bucketKey = this.bucketKeyProjection.apply(CdcRecordUtils.projectAsInsert(this.record, this.bucketKeyFields));
        }
        if (this.bucket == null) {
            this.bucket = this.bucketFunction.bucket(this.bucketKey, this.numBuckets);
        }
        return this.bucket;
    }

    @Override
    public BinaryRow trimmedPrimaryKey() {
        if (this.trimmedPK == null) {
            this.trimmedPK = this.trimmedPKProjection.apply(CdcRecordUtils.projectAsInsert(this.record, this.trimmedPKFields));
        }
        return this.trimmedPK;
    }

    @Override
    public BinaryRow logPrimaryKey() {
        throw new UnsupportedOperationException();
    }
}

