/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.coordinator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.paimon.Snapshot;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.index.IndexFileMetaSerializer;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFileMetaSerializer;

public class ScanCoordinationResponse
implements CoordinationResponse {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final Snapshot snapshot;
    @Nullable
    private final Integer totalBuckets;
    @Nullable
    private final List<byte[]> dataFiles;
    @Nullable
    private final byte[] dynamicBucketIndex;
    @Nullable
    private final List<byte[]> deleteVectorsIndex;

    public ScanCoordinationResponse(@Nullable Snapshot snapshot, @Nullable Integer totalBuckets, @Nullable List<DataFileMeta> dataFiles, @Nullable IndexFileMeta dynamicBucketIndex, @Nullable List<IndexFileMeta> deleteVectorsIndex) throws IOException {
        this.snapshot = snapshot;
        this.totalBuckets = totalBuckets;
        DataFileMetaSerializer serializer = new DataFileMetaSerializer();
        if (dataFiles != null) {
            this.dataFiles = new ArrayList<byte[]>(dataFiles.size());
            for (DataFileMeta dataFile : dataFiles) {
                this.dataFiles.add(serializer.serializeToBytes(dataFile));
            }
        } else {
            this.dataFiles = null;
        }
        IndexFileMetaSerializer indexSerializer = new IndexFileMetaSerializer();
        this.dynamicBucketIndex = (byte[])(dynamicBucketIndex != null ? indexSerializer.serializeToBytes(dynamicBucketIndex) : null);
        if (deleteVectorsIndex != null) {
            this.deleteVectorsIndex = new ArrayList<byte[]>(deleteVectorsIndex.size());
            for (IndexFileMeta indexFile : deleteVectorsIndex) {
                this.deleteVectorsIndex.add(indexSerializer.serializeToBytes(indexFile));
            }
        } else {
            this.deleteVectorsIndex = null;
        }
    }

    @Nullable
    public Snapshot snapshot() {
        return this.snapshot;
    }

    @Nullable
    public Integer totalBuckets() {
        return this.totalBuckets;
    }

    @Nullable
    public List<DataFileMeta> extractDataFiles() throws IOException {
        if (this.dataFiles == null) {
            return null;
        }
        DataFileMetaSerializer serializer = new DataFileMetaSerializer();
        ArrayList<DataFileMeta> dataFileMetas = new ArrayList<DataFileMeta>(this.dataFiles.size());
        for (byte[] file : this.dataFiles) {
            dataFileMetas.add((DataFileMeta)serializer.deserializeFromBytes(file));
        }
        return dataFileMetas;
    }

    @Nullable
    public IndexFileMeta extractDynamicBucketIndex() throws IOException {
        if (this.dynamicBucketIndex == null) {
            return null;
        }
        return (IndexFileMeta)new IndexFileMetaSerializer().deserializeFromBytes(this.dynamicBucketIndex);
    }

    @Nullable
    public List<IndexFileMeta> extractDeletionVectorsIndex() throws IOException {
        if (this.deleteVectorsIndex == null) {
            return null;
        }
        IndexFileMetaSerializer serializer = new IndexFileMetaSerializer();
        ArrayList<IndexFileMeta> metas = new ArrayList<IndexFileMeta>(this.deleteVectorsIndex.size());
        for (byte[] file : this.deleteVectorsIndex) {
            metas.add((IndexFileMeta)serializer.deserializeFromBytes(file));
        }
        return metas;
    }
}

