/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.json.JsonOptions;
import org.apache.paimon.format.text.BaseTextFileReader;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.JsonSerdeUtil;

public class JsonFileReader
extends BaseTextFileReader {
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private final JsonOptions options;

    public JsonFileReader(FileIO fileIO, Path filePath, RowType rowType, JsonOptions options) throws IOException {
        super(fileIO, filePath, rowType);
        this.options = options;
    }

    @Override
    protected BaseTextFileReader.BaseTextRecordIterator createRecordIterator() {
        return new JsonRecordIterator();
    }

    @Override
    protected InternalRow parseLine(String line) throws IOException {
        try {
            JsonNode jsonNode = JsonSerdeUtil.OBJECT_MAPPER_INSTANCE.readTree(line);
            return (InternalRow)this.convertJsonValue(jsonNode, this.rowType, this.options);
        }
        catch (JsonProcessingException e) {
            if (this.options.ignoreParseErrors()) {
                return null;
            }
            throw new IOException("Failed to parse JSON line: " + line, e);
        }
        catch (RuntimeException e) {
            if (this.options.ignoreParseErrors()) {
                return null;
            }
            throw new IOException("Failed to convert JSON line: " + line, e);
        }
    }

    private Object convertJsonValue(JsonNode node, DataType dataType, JsonOptions options) {
        if (node == null || node.isNull()) {
            return null;
        }
        switch (dataType.getTypeRoot()) {
            case BINARY: 
            case VARBINARY: {
                try {
                    return BASE64_DECODER.decode(node.asText());
                }
                catch (Exception e) {
                    return this.handleParseError(e);
                }
            }
            case ARRAY: {
                return this.convertJsonArray(node, (ArrayType)dataType, options);
            }
            case MAP: {
                return this.convertJsonMap(node, (MapType)dataType, options);
            }
            case ROW: {
                return this.convertJsonRow(node, (RowType)dataType, options);
            }
        }
        return this.convertPrimitiveStringToType(node.asText(), dataType, options);
    }

    private GenericArray convertJsonArray(JsonNode arrayNode, ArrayType arrayType, JsonOptions options) {
        if (!arrayNode.isArray()) {
            return (GenericArray)this.handleParseError(new RuntimeException("Expected array node but got: " + (Object)((Object)arrayNode.getNodeType())));
        }
        int size = arrayNode.size();
        ArrayList<Object> elements = new ArrayList<Object>(size);
        DataType elementType = arrayType.getElementType();
        for (int i = 0; i < size; ++i) {
            try {
                Object element = this.convertJsonValue(arrayNode.get(i), elementType, options);
                elements.add(element);
                continue;
            }
            catch (Exception e) {
                Object elementValue = this.handleParseError(e);
                elements.add(elementValue);
            }
        }
        return new GenericArray(elements.toArray());
    }

    private GenericMap convertJsonMap(JsonNode objectNode, MapType mapType, JsonOptions options) {
        if (!objectNode.isObject()) {
            return (GenericMap)this.handleParseError(new IllegalArgumentException("Expected object node but got: " + (Object)((Object)objectNode.getNodeType())));
        }
        LinkedHashMap map = new LinkedHashMap(objectNode.size());
        JsonOptions.MapNullKeyMode mapNullKeyMode = options.getMapNullKeyMode();
        String mapNullKeyLiteral = options.getMapNullKeyLiteral();
        DataType keyType = mapType.getKeyType();
        DataType valueType = mapType.getValueType();
        objectNode.fields().forEachRemaining((? super E field) -> {
            try {
                Object key;
                String keyStr = (String)field.getKey();
                if (keyStr == null) {
                    switch (mapNullKeyMode) {
                        case DROP: {
                            return;
                        }
                        case FAIL: {
                            if (options.ignoreParseErrors()) {
                                return;
                            }
                            throw new RuntimeException("Null map key encountered and map-null-key-mode is set to FAIL.");
                        }
                        case LITERAL: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown MapNullKeyMode: " + mapNullKeyMode);
                        }
                    }
                }
                if ((key = keyStr == null ? this.convertPrimitiveStringToType(mapNullKeyLiteral, keyType, options) : this.convertPrimitiveStringToType(keyStr, keyType, options)) != null) {
                    Object value = this.convertJsonValue((JsonNode)field.getValue(), valueType, options);
                    map.put(key, value);
                }
            }
            catch (Exception e) {
                this.handleParseError(e);
            }
        });
        return new GenericMap(map);
    }

    private Object convertPrimitiveStringToType(String str, DataType dataType, JsonOptions options) {
        try {
            switch (dataType.getTypeRoot()) {
                case TINYINT: {
                    return Byte.parseByte(str);
                }
                case SMALLINT: {
                    return Short.parseShort(str);
                }
                case INTEGER: {
                    return Integer.parseInt(str);
                }
                case BIGINT: {
                    return Long.parseLong(str);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(str));
                }
                case DOUBLE: {
                    return Double.parseDouble(str);
                }
                case BOOLEAN: {
                    return Boolean.parseBoolean(str);
                }
                case CHAR: 
                case VARCHAR: {
                    return BinaryString.fromString(str);
                }
            }
            BinaryString binaryString = BinaryString.fromString(str);
            CastExecutor<?, ?> cast = CastExecutors.resolve(DataTypes.STRING(), dataType);
            return cast.cast(binaryString);
        }
        catch (Exception e) {
            return this.handleParseError(e);
        }
    }

    private GenericRow convertJsonRow(JsonNode objectNode, RowType rowType, JsonOptions options) {
        if (!objectNode.isObject()) {
            return (GenericRow)this.handleParseError(new IllegalArgumentException("Expected object node but got: " + (Object)((Object)objectNode.getNodeType())));
        }
        List<DataField> fields = rowType.getFields();
        int fieldCount = fields.size();
        Object[] values = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            DataField field = fields.get(i);
            try {
                values[i] = this.convertJsonValue(objectNode.get(field.name()), field.type(), options);
                continue;
            }
            catch (Exception e) {
                values[i] = this.handleParseError(e);
            }
        }
        return GenericRow.of(values);
    }

    private <T> T handleParseError(Exception exception) {
        if (this.options.ignoreParseErrors()) {
            return null;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    private class JsonRecordIterator
    extends BaseTextFileReader.BaseTextRecordIterator {
        private JsonRecordIterator() {
            super(JsonFileReader.this);
        }
    }
}

