/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.iceberg.manifest.IcebergDataFileMetaSerializer;
import org.apache.paimon.iceberg.manifest.IcebergManifestEntry;
import org.apache.paimon.iceberg.manifest.IcebergManifestFileMeta;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ObjectSerializer;

public class IcebergManifestEntrySerializer
extends ObjectSerializer<IcebergManifestEntry> {
    private static final long serialVersionUID = 1L;
    private final IcebergDataFileMetaSerializer fileSerializer;

    public IcebergManifestEntrySerializer(RowType partitionType) {
        super(IcebergManifestEntry.schema(partitionType));
        this.fileSerializer = new IcebergDataFileMetaSerializer(partitionType);
    }

    @Override
    public InternalRow toRow(IcebergManifestEntry entry) {
        return GenericRow.of(entry.status().id(), entry.snapshotId(), entry.sequenceNumber(), entry.fileSequenceNumber(), this.fileSerializer.toRow(entry.file()));
    }

    @Override
    public IcebergManifestEntry fromRow(InternalRow row) {
        return new IcebergManifestEntry(IcebergManifestEntry.Status.fromId(row.getInt(0)), row.getLong(1), row.getLong(2), row.getLong(3), this.fileSerializer.fromRow(row.getRow(4, this.fileSerializer.numFields())));
    }

    public IcebergManifestEntry fromRow(InternalRow row, IcebergManifestFileMeta meta) {
        IcebergManifestEntry.Status status = IcebergManifestEntry.Status.fromId(row.getInt(0));
        long snapshotId = row.isNullAt(1) ? meta.addedSnapshotId() : row.getLong(1);
        long sequenceNumber = this.getOrInherit(row, meta, 2, status);
        long fileSequenceNumber = this.getOrInherit(row, meta, 3, status);
        return new IcebergManifestEntry(status, snapshotId, sequenceNumber, fileSequenceNumber, this.fileSerializer.fromRow(row.getRow(4, this.fileSerializer.numFields())));
    }

    private long getOrInherit(InternalRow row, IcebergManifestFileMeta meta, int pos, IcebergManifestEntry.Status status) {
        long sequenceNumber = meta.sequenceNumber();
        if (row.isNullAt(pos) && (sequenceNumber == 0L || status == IcebergManifestEntry.Status.ADDED)) {
            return sequenceNumber;
        }
        return row.getLong(pos);
    }
}

