/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.metadata;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IcebergRef {
    private static final String FIELD_SNAPSHOT_ID = "snapshot-id";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_MAX_REF_AGE_MS = "max-ref-age-ms";
    @JsonProperty(value="snapshot-id")
    private final long snapshotId;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="max-ref-age-ms")
    @Nullable
    private final Long maxRefAgeMs;

    @JsonCreator
    public IcebergRef(@JsonProperty(value="snapshot-id") long snapshotId) {
        this.snapshotId = snapshotId;
        this.type = "tag";
        this.maxRefAgeMs = Long.MAX_VALUE;
    }

    @JsonGetter(value="snapshot-id")
    public long snapshotId() {
        return this.snapshotId;
    }

    @JsonGetter(value="type")
    public String type() {
        return this.type;
    }

    @JsonGetter(value="max-ref-age-ms")
    public Long maxRefAgeMs() {
        return this.maxRefAgeMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IcebergRef)) {
            return false;
        }
        IcebergRef that = (IcebergRef)o;
        return this.snapshotId == that.snapshotId && this.type.equals(that.type) && this.maxRefAgeMs == that.maxRefAgeMs;
    }

    public int hashCode() {
        return Objects.hash(this.snapshotId, this.type, this.maxRefAgeMs);
    }
}

