/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.io.DataFileMeta;

public class CompactIncrement {
    private final List<DataFileMeta> compactBefore;
    private final List<DataFileMeta> compactAfter;
    private final List<DataFileMeta> changelogFiles;
    private final List<IndexFileMeta> newIndexFiles;
    private final List<IndexFileMeta> deletedIndexFiles;

    public CompactIncrement(List<DataFileMeta> compactBefore, List<DataFileMeta> compactAfter, List<DataFileMeta> changelogFiles) {
        this(compactBefore, compactAfter, changelogFiles, new ArrayList<IndexFileMeta>(), new ArrayList<IndexFileMeta>());
    }

    public CompactIncrement(List<DataFileMeta> compactBefore, List<DataFileMeta> compactAfter, List<DataFileMeta> changelogFiles, List<IndexFileMeta> newIndexFiles, List<IndexFileMeta> deletedIndexFiles) {
        this.compactBefore = compactBefore;
        this.compactAfter = compactAfter;
        this.changelogFiles = changelogFiles;
        this.newIndexFiles = newIndexFiles;
        this.deletedIndexFiles = deletedIndexFiles;
    }

    public List<DataFileMeta> compactBefore() {
        return this.compactBefore;
    }

    public List<DataFileMeta> compactAfter() {
        return this.compactAfter;
    }

    public List<DataFileMeta> changelogFiles() {
        return this.changelogFiles;
    }

    public List<IndexFileMeta> newIndexFiles() {
        return this.newIndexFiles;
    }

    public List<IndexFileMeta> deletedIndexFiles() {
        return this.deletedIndexFiles;
    }

    public boolean isEmpty() {
        return this.compactBefore.isEmpty() && this.compactAfter.isEmpty() && this.changelogFiles.isEmpty() && this.newIndexFiles.isEmpty() && this.deletedIndexFiles.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactIncrement that = (CompactIncrement)o;
        return Objects.equals(this.compactBefore, that.compactBefore) && Objects.equals(this.compactAfter, that.compactAfter) && Objects.equals(this.changelogFiles, that.changelogFiles) && Objects.equals(this.newIndexFiles, that.newIndexFiles) && Objects.equals(this.deletedIndexFiles, that.deletedIndexFiles);
    }

    public int hashCode() {
        return Objects.hash(this.compactBefore, this.compactAfter, this.changelogFiles);
    }

    public String toString() {
        return String.format("CompactIncrement {compactBefore = %s, compactAfter = %s, changelogFiles = %s, newIndexFiles = %s, deletedIndexFiles = %s}", this.compactBefore.stream().map(DataFileMeta::fileName).collect(Collectors.toList()), this.compactAfter.stream().map(DataFileMeta::fileName).collect(Collectors.toList()), this.changelogFiles.stream().map(DataFileMeta::fileName).collect(Collectors.toList()), this.newIndexFiles.stream().map(IndexFileMeta::fileName).collect(Collectors.toList()), this.deletedIndexFiles.stream().map(IndexFileMeta::fileName).collect(Collectors.toList()));
    }

    public static CompactIncrement emptyIncrement() {
        return new CompactIncrement(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }
}

