/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fileindex.FileIndexCommon;
import org.apache.paimon.fileindex.FileIndexFormat;
import org.apache.paimon.fileindex.FileIndexOptions;
import org.apache.paimon.fileindex.FileIndexWriter;
import org.apache.paimon.fileindex.FileIndexer;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.options.Options;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;

public final class DataFileIndexWriter
implements Closeable {
    public static final FileIndexResult EMPTY_RESULT = FileIndexResult.of(null, null);
    private final FileIO fileIO;
    private final Path path;
    private final long inManifestThreshold;
    private final Map<String, Map<String, IndexMaintainer>> indexMaintainers = new HashMap<String, Map<String, IndexMaintainer>>();
    private String resultFileName;
    private byte[] embeddedIndexBytes;

    public DataFileIndexWriter(FileIO fileIO, Path path, RowType rowType, FileIndexOptions fileIndexOptions, @Nullable Map<String, String> colNameMapping) {
        this.fileIO = fileIO;
        this.path = path;
        List<DataField> fields = rowType.getFields();
        HashMap map = new HashMap();
        HashMap index = new HashMap();
        fields.forEach(dataField -> {
            map.put(dataField.name(), dataField);
            index.put(dataField.name(), rowType.getFieldIndex(dataField.name()));
        });
        for (Map.Entry<FileIndexOptions.Column, Map<String, Options>> entry : fileIndexOptions.entrySet()) {
            FileIndexOptions.Column entryColumn = entry.getKey();
            String colName = entryColumn.getColumnName();
            if (colNameMapping != null && (colName = (String)colNameMapping.getOrDefault(colName, null)) == null) continue;
            String columnName = colName;
            DataField field = (DataField)map.get(columnName);
            if (field == null) {
                throw new IllegalArgumentException(columnName + " does not exist in column fields");
            }
            for (Map.Entry<String, Options> typeEntry : entry.getValue().entrySet()) {
                String indexType = typeEntry.getKey();
                Map column2maintainers = this.indexMaintainers.computeIfAbsent(indexType, k -> new HashMap());
                IndexMaintainer maintainer = (IndexMaintainer)column2maintainers.get(columnName);
                if (entryColumn.isNestedColumn()) {
                    if (field.type().getTypeRoot() != DataTypeRoot.MAP) {
                        throw new IllegalArgumentException("Column " + columnName + " is nested column, but is not map type. Only should map type yet.");
                    }
                    MapFileIndexMaintainer mapMaintainer = (MapFileIndexMaintainer)maintainer;
                    if (mapMaintainer == null) {
                        MapType mapType = (MapType)field.type();
                        mapMaintainer = new MapFileIndexMaintainer(columnName, indexType, mapType.getKeyType(), mapType.getValueType(), fileIndexOptions.getMapTopLevelOptions(columnName, typeEntry.getKey()), (Integer)index.get(columnName));
                        column2maintainers.put(columnName, mapMaintainer);
                    }
                    mapMaintainer.add(entryColumn.getNestedColumnName(), typeEntry.getValue());
                    continue;
                }
                if (maintainer != null) continue;
                maintainer = new FileIndexMaintainer(columnName, indexType, FileIndexer.create(indexType, field.type(), typeEntry.getValue()).createWriter(), InternalRow.createFieldGetter(field.type(), (Integer)index.get(columnName)));
                column2maintainers.put(columnName, maintainer);
            }
        }
        this.inManifestThreshold = fileIndexOptions.fileIndexInManifestThreshold();
    }

    public void write(InternalRow row) {
        this.indexMaintainers.values().forEach(column2maintainers -> column2maintainers.values().forEach(index -> index.write(row)));
    }

    @Override
    public void close() throws IOException {
        Map<String, Map<String, byte[]>> indexMaps = this.serializeMaintainers();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (FileIndexFormat.Writer writer = FileIndexFormat.createWriter(out);){
            writer.writeColumnIndexes(indexMaps);
        }
        if ((long)out.size() > this.inManifestThreshold) {
            var4_4 = null;
            try (PositionOutputStream outputStream = this.fileIO.newOutputStream(this.path, true);){
                ((OutputStream)outputStream).write(out.toByteArray());
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
            this.resultFileName = this.path.getName();
        } else {
            this.embeddedIndexBytes = out.toByteArray();
        }
    }

    public Map<String, Map<String, byte[]>> serializeMaintainers() {
        HashMap<String, Map<String, byte[]>> indexMaps = new HashMap<String, Map<String, byte[]>>();
        for (Map<String, IndexMaintainer> columnIndexMaintainers : this.indexMaintainers.values()) {
            for (IndexMaintainer indexMaintainer : columnIndexMaintainers.values()) {
                Map<String, byte[]> mapBytes = indexMaintainer.serializedBytes();
                for (Map.Entry<String, byte[]> entry : mapBytes.entrySet()) {
                    indexMaps.computeIfAbsent(entry.getKey(), k -> new HashMap()).put(indexMaintainer.getIndexType(), entry.getValue());
                }
            }
        }
        return indexMaps;
    }

    public FileIndexResult result() {
        return FileIndexResult.of(this.embeddedIndexBytes, this.resultFileName);
    }

    @Nullable
    public static DataFileIndexWriter create(FileIO fileIO, Path path, RowType rowType, FileIndexOptions fileIndexOptions) {
        return DataFileIndexWriter.create(fileIO, path, rowType, fileIndexOptions, null);
    }

    @Nullable
    public static DataFileIndexWriter create(FileIO fileIO, Path path, RowType rowType, FileIndexOptions fileIndexOptions, @Nullable Map<String, String> colNameMapping) {
        return fileIndexOptions.isEmpty() ? null : new DataFileIndexWriter(fileIO, path, rowType, fileIndexOptions, colNameMapping);
    }

    private static class MapFileIndexMaintainer
    implements IndexMaintainer {
        private final String columnName;
        private final String indexType;
        private final Options options;
        private final DataType valueType;
        private final Map<String, FileIndexWriter> indexWritersMap;
        private final InternalArray.ElementGetter valueElementGetter;
        private final int position;

        public MapFileIndexMaintainer(String columnName, String indexType, DataType keyType, DataType valueType, Options options, int position) {
            this.columnName = columnName;
            this.indexType = indexType;
            this.valueType = valueType;
            this.options = options;
            this.position = position;
            this.indexWritersMap = new HashMap<String, FileIndexWriter>();
            this.valueElementGetter = InternalArray.createElementGetter(valueType);
            DataTypeRoot rootType = keyType.getTypeRoot();
            if (rootType != DataTypeRoot.CHAR && rootType != DataTypeRoot.VARCHAR) {
                throw new IllegalArgumentException("Only support map data type with key field of CHAR\u3001VARCHAR\u3001STRING.");
            }
        }

        @Override
        public void write(InternalRow row) {
            if (row.isNullAt(this.position)) {
                this.indexWritersMap.values().forEach(write -> write.writeRecord(null));
                return;
            }
            InternalMap internalMap = row.getMap(this.position);
            InternalArray keyArray = internalMap.keyArray();
            InternalArray valueArray = internalMap.valueArray();
            HashSet<String> writtenKeys = new HashSet<String>();
            for (int i = 0; i < keyArray.size(); ++i) {
                String key = keyArray.getString(i).toString();
                FileIndexWriter writer = this.indexWritersMap.getOrDefault(key, null);
                if (writer == null) continue;
                writtenKeys.add(key);
                writer.writeRecord(this.valueElementGetter.getElementOrNull(valueArray, i));
            }
            for (Map.Entry<String, FileIndexWriter> writerEntry : this.indexWritersMap.entrySet()) {
                if (writtenKeys.contains(writerEntry.getKey())) continue;
                writerEntry.getValue().writeRecord(null);
            }
        }

        public void add(String nestedKey, Options nestedOptions) {
            this.indexWritersMap.put(nestedKey, FileIndexer.create(this.indexType, this.valueType, new Options(this.options.toMap(), nestedOptions.toMap())).createWriter());
        }

        @Override
        public String getIndexType() {
            return this.indexType;
        }

        @Override
        public Map<String, byte[]> serializedBytes() {
            HashMap<String, byte[]> result = new HashMap<String, byte[]>();
            this.indexWritersMap.forEach((k, v) -> {
                if (!v.empty()) {
                    result.put(FileIndexCommon.toMapKey(this.columnName, k), v.serializedBytes());
                } else {
                    result.put(FileIndexCommon.toMapKey(this.columnName, k), null);
                }
            });
            return result;
        }
    }

    private static class FileIndexMaintainer
    implements IndexMaintainer {
        private final String columnName;
        private final String indexType;
        private final FileIndexWriter fileIndexWriter;
        private final InternalRow.FieldGetter getter;

        public FileIndexMaintainer(String columnName, String indexType, FileIndexWriter fileIndexWriter, InternalRow.FieldGetter getter) {
            this.columnName = columnName;
            this.indexType = indexType;
            this.fileIndexWriter = fileIndexWriter;
            this.getter = getter;
        }

        @Override
        public void write(InternalRow row) {
            this.fileIndexWriter.writeRecord(this.getter.getFieldOrNull(row));
        }

        @Override
        public String getIndexType() {
            return this.indexType;
        }

        @Override
        public Map<String, byte[]> serializedBytes() {
            return Collections.singletonMap(this.columnName, this.fileIndexWriter.serializedBytes());
        }
    }

    static interface IndexMaintainer {
        public void write(InternalRow var1);

        public String getIndexType();

        public Map<String, byte[]> serializedBytes();
    }

    public static interface FileIndexResult {
        @Nullable
        public byte[] embeddedIndexBytes();

        @Nullable
        public String independentIndexFile();

        public static FileIndexResult of(final byte[] embeddedIndexBytes, final String resultFileName) {
            return new FileIndexResult(){

                @Override
                public byte[] embeddedIndexBytes() {
                    return embeddedIndexBytes;
                }

                @Override
                public String independentIndexFile() {
                    return resultFileName;
                }
            };
        }
    }
}

