/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.io.DataFileMeta;

public class DataIncrement {
    private final List<DataFileMeta> newFiles;
    private final List<DataFileMeta> deletedFiles;
    private final List<DataFileMeta> changelogFiles;
    private final List<IndexFileMeta> newIndexFiles;
    private final List<IndexFileMeta> deletedIndexFiles;

    public DataIncrement(List<DataFileMeta> newFiles, List<DataFileMeta> deletedFiles, List<DataFileMeta> changelogFiles) {
        this(newFiles, deletedFiles, changelogFiles, new ArrayList<IndexFileMeta>(), new ArrayList<IndexFileMeta>());
    }

    public DataIncrement(List<DataFileMeta> newFiles, List<DataFileMeta> deletedFiles, List<DataFileMeta> changelogFiles, List<IndexFileMeta> newIndexFiles, List<IndexFileMeta> deletedIndexFiles) {
        this.newFiles = newFiles;
        this.deletedFiles = deletedFiles;
        this.changelogFiles = changelogFiles;
        this.newIndexFiles = newIndexFiles;
        this.deletedIndexFiles = deletedIndexFiles;
    }

    public static DataIncrement emptyIncrement() {
        return new DataIncrement(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public List<DataFileMeta> newFiles() {
        return this.newFiles;
    }

    public List<DataFileMeta> deletedFiles() {
        return this.deletedFiles;
    }

    public List<DataFileMeta> changelogFiles() {
        return this.changelogFiles;
    }

    public List<IndexFileMeta> newIndexFiles() {
        return this.newIndexFiles;
    }

    public List<IndexFileMeta> deletedIndexFiles() {
        return this.deletedIndexFiles;
    }

    public boolean isEmpty() {
        return this.newFiles.isEmpty() && this.deletedFiles.isEmpty() && this.changelogFiles.isEmpty() && this.newIndexFiles.isEmpty() && this.deletedIndexFiles.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataIncrement that = (DataIncrement)o;
        return Objects.equals(this.newFiles, that.newFiles) && Objects.equals(this.deletedFiles, that.deletedFiles) && Objects.equals(this.changelogFiles, that.changelogFiles) && Objects.equals(this.newIndexFiles, that.newIndexFiles) && Objects.equals(this.deletedIndexFiles, that.deletedIndexFiles);
    }

    public int hashCode() {
        return Objects.hash(this.newFiles, this.deletedFiles, this.changelogFiles, this.newIndexFiles, this.deletedIndexFiles);
    }

    public String toString() {
        return String.format("DataIncrement {newFiles = %s, deletedFiles = %s, changelogFiles = %s, newIndexFiles = %s, deletedIndexFiles = %s}", this.newFiles.stream().map(DataFileMeta::fileName).collect(Collectors.toList()), this.deletedFiles.stream().map(DataFileMeta::fileName).collect(Collectors.toList()), this.changelogFiles.stream().map(DataFileMeta::fileName).collect(Collectors.toList()), this.newIndexFiles.stream().map(IndexFileMeta::fileName).collect(Collectors.toList()), this.deletedIndexFiles.stream().map(IndexFileMeta::fileName).collect(Collectors.toList()));
    }
}

