/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.append.AppendOnlyWriter;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.BucketedDvMaintainer;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.fileindex.FileIndexOptions;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.BundleRecords;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.RowDataRollingFileWriter;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.operation.AbstractFileStoreWrite;
import org.apache.paimon.operation.BundleFileStoreWriter;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.MemoryFileStoreWrite;
import org.apache.paimon.operation.RawFileSplitRead;
import org.apache.paimon.reader.RecordReaderIterator;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CommitIncrement;
import org.apache.paimon.utils.ExceptionUtils;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.IOExceptionSupplier;
import org.apache.paimon.utils.LongCounter;
import org.apache.paimon.utils.RecordWriter;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.StatsCollectorFactories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAppendFileStoreWrite
extends MemoryFileStoreWrite<InternalRow>
implements BundleFileStoreWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAppendFileStoreWrite.class);
    private final FileIO fileIO;
    private final RawFileSplitRead readForCompact;
    private final long schemaId;
    private final FileFormat fileFormat;
    private final FileStorePathFactory pathFactory;
    private final FileIndexOptions fileIndexOptions;
    private final RowType rowType;
    private RowType writeType;
    @Nullable
    private List<String> writeCols;
    private boolean forceBufferSpill = false;

    public BaseAppendFileStoreWrite(FileIO fileIO, RawFileSplitRead readForCompact, long schemaId, RowType rowType, RowType partitionType, FileStorePathFactory pathFactory, SnapshotManager snapshotManager, FileStoreScan scan, CoreOptions options, @Nullable BucketedDvMaintainer.Factory dvMaintainerFactory, String tableName) {
        super(snapshotManager, scan, options, partitionType, null, dvMaintainerFactory, tableName);
        this.fileIO = fileIO;
        this.readForCompact = readForCompact;
        this.schemaId = schemaId;
        this.rowType = rowType;
        this.writeType = rowType;
        this.writeCols = null;
        this.fileFormat = FileFormat.fileFormat(options);
        this.pathFactory = pathFactory;
        this.fileIndexOptions = options.indexColumnsOptions();
    }

    @Override
    protected RecordWriter<InternalRow> createWriter(BinaryRow partition, int bucket, List<DataFileMeta> restoredFiles, long restoredMaxSeqNumber, @Nullable CommitIncrement restoreIncrement, ExecutorService compactExecutor, @Nullable BucketedDvMaintainer dvMaintainer) {
        return new AppendOnlyWriter(this.fileIO, this.ioManager, this.schemaId, this.fileFormat, this.options.targetFileSize(false), this.writeType, this.writeCols, restoredMaxSeqNumber, this.getCompactManager(partition, bucket, restoredFiles, compactExecutor, dvMaintainer), files -> this.createFilesIterator(partition, bucket, (List<DataFileMeta>)files, null), this.options.commitForceCompact(), this.pathFactory.createDataFilePathFactory(partition, bucket), restoreIncrement, this.options.useWriteBufferForAppend() || this.forceBufferSpill, this.options.writeBufferSpillable() || this.forceBufferSpill, this.options.fileCompression(), this.options.spillCompressOptions(), this.statsCollectors(), this.options.writeBufferSpillDiskSize(), this.fileIndexOptions, this.options.asyncFileWrite(), this.options.statsDenseStore());
    }

    @Override
    public void withWriteType(RowType writeType) {
        this.writeType = writeType;
        int fullCount = this.rowType.getFieldCount();
        List<String> fullNames = this.rowType.getFieldNames();
        this.writeCols = writeType.getFieldNames();
        if (this.writeCols.size() >= fullCount && this.writeCols.subList(0, fullCount).equals(fullNames)) {
            this.writeCols = null;
        }
    }

    private SimpleColStatsCollector.Factory[] statsCollectors() {
        return StatsCollectorFactories.createStatsFactories(this.options.statsMode(), this.options, this.writeType.getFieldNames());
    }

    protected abstract CompactManager getCompactManager(BinaryRow var1, int var2, List<DataFileMeta> var3, ExecutorService var4, @Nullable BucketedDvMaintainer var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataFileMeta> compactRewrite(BinaryRow partition, int bucket, @Nullable Function<String, DeletionVector> dvFactory, List<DataFileMeta> toCompact) throws Exception {
        if (toCompact.isEmpty()) {
            return Collections.emptyList();
        }
        Exception collectedExceptions = null;
        RowDataRollingFileWriter rewriter = this.createRollingFileWriter(partition, bucket, new LongCounter(toCompact.get(0).minSequenceNumber()));
        HashMap<String, IOExceptionSupplier<DeletionVector>> dvFactories = null;
        if (dvFactory != null) {
            dvFactories = new HashMap<String, IOExceptionSupplier<DeletionVector>>();
            for (DataFileMeta file : toCompact) {
                dvFactories.put(file.fileName(), () -> (DeletionVector)dvFactory.apply(file.fileName()));
            }
        }
        try {
            rewriter.write(this.createFilesIterator(partition, bucket, toCompact, dvFactories));
        }
        catch (Exception e) {
            collectedExceptions = e;
        }
        finally {
            try {
                rewriter.close();
            }
            catch (Exception e) {
                collectedExceptions = ExceptionUtils.firstOrSuppressed(e, collectedExceptions);
            }
        }
        if (collectedExceptions != null) {
            throw collectedExceptions;
        }
        return rewriter.result();
    }

    private RowDataRollingFileWriter createRollingFileWriter(BinaryRow partition, int bucket, LongCounter seqNumCounter) {
        return new RowDataRollingFileWriter(this.fileIO, this.schemaId, this.fileFormat, this.options.targetFileSize(false), this.writeType, this.pathFactory.createDataFilePathFactory(partition, bucket), seqNumCounter, this.options.fileCompression(), this.statsCollectors(), this.fileIndexOptions, FileSource.COMPACT, this.options.asyncFileWrite(), this.options.statsDenseStore(), this.rowType.equals(this.writeType) ? null : this.writeType.getFieldNames());
    }

    private RecordReaderIterator<InternalRow> createFilesIterator(BinaryRow partition, int bucket, List<DataFileMeta> files, @Nullable Map<String, IOExceptionSupplier<DeletionVector>> dvFactories) throws IOException {
        return new RecordReaderIterator<InternalRow>(this.readForCompact.createReader(partition, bucket, files, dvFactories));
    }

    @Override
    protected void forceBufferSpill() throws Exception {
        if (this.ioManager == null) {
            return;
        }
        if (this.forceBufferSpill) {
            return;
        }
        this.forceBufferSpill = true;
        LOG.info("Force buffer spill for append-only file store write, writer number is: {}", (Object)this.writers.size());
        for (Map bucketWriters : this.writers.values()) {
            for (AbstractFileStoreWrite.WriterContainer writerContainer : bucketWriters.values()) {
                ((AppendOnlyWriter)writerContainer.writer).toBufferedWriter();
            }
        }
    }

    @Override
    public void writeBundle(BinaryRow partition, int bucket, BundleRecords bundle) throws Exception {
        AbstractFileStoreWrite.WriterContainer container = this.getWriterWrapper(partition, bucket);
        ((AppendOnlyWriter)container.writer).writeBundle(bundle);
    }
}

