/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.TopN;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IOFunction;

public interface SplitRead<T> {
    public SplitRead<T> forceKeepDelete();

    public SplitRead<T> withIOManager(@Nullable IOManager var1);

    public SplitRead<T> withReadType(RowType var1);

    public SplitRead<T> withFilter(@Nullable Predicate var1);

    default public SplitRead<T> withTopN(@Nullable TopN topN) {
        return this;
    }

    default public SplitRead<T> withLimit(@Nullable Integer limit) {
        return this;
    }

    public RecordReader<T> createReader(DataSplit var1) throws IOException;

    public static <L, R> SplitRead<R> convert(final SplitRead<L> read, final IOFunction<DataSplit, RecordReader<R>> convertedFactory) {
        return new SplitRead<R>(){

            @Override
            public SplitRead<R> forceKeepDelete() {
                read.forceKeepDelete();
                return this;
            }

            @Override
            public SplitRead<R> withIOManager(@Nullable IOManager ioManager) {
                read.withIOManager(ioManager);
                return this;
            }

            @Override
            public SplitRead<R> withReadType(RowType readType) {
                read.withReadType(readType);
                return this;
            }

            @Override
            public SplitRead<R> withFilter(@Nullable Predicate predicate) {
                read.withFilter(predicate);
                return this;
            }

            @Override
            public RecordReader<R> createReader(DataSplit split) throws IOException {
                return (RecordReader)convertedFactory.apply(split);
            }
        };
    }
}

