/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.object;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.RemoteIterator;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.object.ObjectTable;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;

public class ObjectTableImpl
implements ReadonlyTable,
ObjectTable {
    private final Identifier identifier;
    private final FileIO fileIO;
    private final String location;
    @Nullable
    private final String comment;

    public ObjectTableImpl(Identifier identifier, FileIO fileIO, String location, @Nullable String comment) {
        this.identifier = identifier;
        this.fileIO = fileIO;
        this.location = location;
        this.comment = comment;
    }

    @Override
    public String name() {
        return this.identifier.getTableName();
    }

    @Override
    public String fullName() {
        return this.identifier.getFullName();
    }

    @Override
    public RowType rowType() {
        return SCHEMA;
    }

    @Override
    public List<String> partitionKeys() {
        return Collections.emptyList();
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> options() {
        return Collections.emptyMap();
    }

    @Override
    public Optional<String> comment() {
        return Optional.ofNullable(this.comment);
    }

    @Override
    public Optional<Statistics> statistics() {
        return ReadonlyTable.super.statistics();
    }

    @Override
    public FileIO fileIO() {
        return this.fileIO;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public ObjectTable copy(Map<String, String> dynamicOptions) {
        return new ObjectTableImpl(this.identifier, this.fileIO, this.location, this.comment);
    }

    @Override
    public InnerTableScan newScan() {
        return new ObjectScan(this);
    }

    @Override
    public InnerTableRead newRead() {
        return new ObjectRead();
    }

    private static InternalRow toRow(String prefix, FileStatus file) {
        String path = file.getPath().toUri().getPath();
        if (!path.startsWith(prefix)) {
            throw new IllegalArgumentException(String.format("File path '%s' does not contain prefix '%s'", path, prefix));
        }
        String relative = path.substring(prefix.length());
        if (relative.startsWith("/")) {
            relative = relative.substring(1);
        }
        return GenericRow.of(BinaryString.fromString(relative), BinaryString.fromString(file.getPath().getName()), file.getLen(), file.getModificationTime(), file.getAccessTime(), BinaryString.fromString(file.getOwner()));
    }

    private static class ObjectRead
    implements InnerTableRead {
        @Nullable
        private RowType readType;

        private ObjectRead() {
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof ObjectSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            ObjectSplit objSplit = (ObjectSplit)split;
            FileIO fileIO = objSplit.fileIO();
            String location = objSplit.location();
            final RemoteIterator<FileStatus> objIter = fileIO.listFilesIterative(new Path(location), true);
            final String prefix = new Path(location).toUri().getPath();
            Iterator<InternalRow> iterator = new Iterator<InternalRow>(){

                @Override
                public boolean hasNext() {
                    try {
                        return objIter.hasNext();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public InternalRow next() {
                    try {
                        return ObjectTableImpl.toRow(prefix, (FileStatus)objIter.next());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            if (this.readType != null) {
                iterator = Iterators.transform(iterator, row -> ProjectedRow.from(this.readType, ObjectTable.SCHEMA).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(iterator);
        }
    }

    private static class ObjectSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;
        private final FileIO fileIO;
        private final String location;

        public ObjectSplit(FileIO fileIO, String location) {
            this.fileIO = fileIO;
            this.location = location;
        }

        public FileIO fileIO() {
            return this.fileIO;
        }

        public String location() {
            return this.location;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectSplit that = (ObjectSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private static class ObjectScan
    extends ReadOnceTableScan {
        private final ObjectTable objectTable;

        public ObjectScan(ObjectTable objectTable) {
            this.objectTable = objectTable;
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new ObjectSplit(this.objectTable.fileIO(), this.objectTable.location()));
        }
    }
}

