/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFileMeta08Serializer;
import org.apache.paimon.io.DataFileMeta09Serializer;
import org.apache.paimon.io.DataFileMeta10LegacySerializer;
import org.apache.paimon.io.DataFileMeta12LegacySerializer;
import org.apache.paimon.io.DataFileMetaFirstRowIdLegacySerializer;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataInputViewStreamWrapper;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.predicate.CompareUtils;
import org.apache.paimon.stats.SimpleStatsEvolution;
import org.apache.paimon.stats.SimpleStatsEvolutions;
import org.apache.paimon.table.source.DeletionFile;
import org.apache.paimon.table.source.IndexFile;
import org.apache.paimon.table.source.RawFile;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.FunctionWithIOException;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializationUtils;

public class DataSplit
implements Split {
    private static final long serialVersionUID = 7L;
    private static final long MAGIC = -2394839472490812314L;
    private static final int VERSION = 8;
    private long snapshotId = 0L;
    private BinaryRow partition;
    private int bucket = -1;
    private String bucketPath;
    @Nullable
    private Integer totalBuckets;
    private List<DataFileMeta> beforeFiles = new ArrayList<DataFileMeta>();
    @Nullable
    private List<DeletionFile> beforeDeletionFiles;
    private List<DataFileMeta> dataFiles;
    @Nullable
    private List<DeletionFile> dataDeletionFiles;
    private boolean isStreaming = false;
    private boolean rawConvertible;

    public long snapshotId() {
        return this.snapshotId;
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public String bucketPath() {
        return this.bucketPath;
    }

    @Nullable
    public Integer totalBuckets() {
        return this.totalBuckets;
    }

    public List<DataFileMeta> beforeFiles() {
        return this.beforeFiles;
    }

    public Optional<List<DeletionFile>> beforeDeletionFiles() {
        return Optional.ofNullable(this.beforeDeletionFiles);
    }

    public List<DataFileMeta> dataFiles() {
        return this.dataFiles;
    }

    @Override
    public Optional<List<DeletionFile>> deletionFiles() {
        return Optional.ofNullable(this.dataDeletionFiles);
    }

    public boolean isStreaming() {
        return this.isStreaming;
    }

    public boolean rawConvertible() {
        return this.rawConvertible;
    }

    public OptionalLong latestFileCreationEpochMillis() {
        return this.dataFiles.stream().mapToLong(DataFileMeta::creationTimeEpochMillis).max();
    }

    public OptionalLong earliestFileCreationEpochMillis() {
        return this.dataFiles.stream().mapToLong(DataFileMeta::creationTimeEpochMillis).min();
    }

    @Override
    public long rowCount() {
        long rowCount = 0L;
        for (DataFileMeta file : this.dataFiles) {
            rowCount += file.rowCount();
        }
        return rowCount;
    }

    public boolean mergedRowCountAvailable() {
        return this.rawConvertible && (this.dataDeletionFiles == null || this.dataDeletionFiles.stream().allMatch(f -> f == null || f.cardinality() != null));
    }

    public long mergedRowCount() {
        Preconditions.checkState(this.mergedRowCountAvailable());
        return this.partialMergedRowCount();
    }

    public Object minValue(int fieldIndex, DataField dataField, SimpleStatsEvolutions evolutions) {
        Object minValue = null;
        for (DataFileMeta dataFile : this.dataFiles) {
            SimpleStatsEvolution evolution = evolutions.getOrCreate(dataFile.schemaId());
            InternalRow minValues = evolution.evolution(dataFile.valueStats().minValues(), dataFile.valueStatsCols());
            Object other = InternalRowUtils.get(minValues, fieldIndex, dataField.type());
            if (minValue == null) {
                minValue = other;
                continue;
            }
            if (other == null || CompareUtils.compareLiteral(dataField.type(), minValue, other) <= 0) continue;
            minValue = other;
        }
        return minValue;
    }

    public Object maxValue(int fieldIndex, DataField dataField, SimpleStatsEvolutions evolutions) {
        Object maxValue = null;
        for (DataFileMeta dataFile : this.dataFiles) {
            SimpleStatsEvolution evolution = evolutions.getOrCreate(dataFile.schemaId());
            InternalRow maxValues = evolution.evolution(dataFile.valueStats().maxValues(), dataFile.valueStatsCols());
            Object other = InternalRowUtils.get(maxValues, fieldIndex, dataField.type());
            if (maxValue == null) {
                maxValue = other;
                continue;
            }
            if (other == null || CompareUtils.compareLiteral(dataField.type(), maxValue, other) >= 0) continue;
            maxValue = other;
        }
        return maxValue;
    }

    public Long nullCount(int fieldIndex, SimpleStatsEvolutions evolutions) {
        Long sum = null;
        for (DataFileMeta dataFile : this.dataFiles) {
            SimpleStatsEvolution evolution = evolutions.getOrCreate(dataFile.schemaId());
            InternalArray nullCounts = evolution.evolution(dataFile.valueStats().nullCounts(), (Long)dataFile.rowCount(), dataFile.valueStatsCols());
            Long nullCount = (Long)InternalRowUtils.get(nullCounts, fieldIndex, DataTypes.BIGINT());
            if (sum == null) {
                sum = nullCount;
                continue;
            }
            if (nullCount == null) continue;
            sum = sum + nullCount;
        }
        return sum;
    }

    public long partialMergedRowCount() {
        List rawFiles;
        long sum = 0L;
        if (this.rawConvertible && (rawFiles = (List)this.convertToRawFiles().orElse(null)) != null) {
            for (int i = 0; i < rawFiles.size(); ++i) {
                RawFile rawFile = (RawFile)rawFiles.get(i);
                if (this.dataDeletionFiles == null || this.dataDeletionFiles.get(i) == null) {
                    sum += rawFile.rowCount();
                    continue;
                }
                if (this.dataDeletionFiles.get(i).cardinality() == null) continue;
                sum += rawFile.rowCount() - this.dataDeletionFiles.get(i).cardinality();
            }
        }
        return sum;
    }

    @Override
    public Optional<List<RawFile>> convertToRawFiles() {
        if (this.rawConvertible) {
            return Optional.of(this.dataFiles.stream().map(f -> this.makeRawTableFile(this.bucketPath, (DataFileMeta)f)).collect(Collectors.toList()));
        }
        return Optional.empty();
    }

    private RawFile makeRawTableFile(String bucketPath, DataFileMeta file) {
        return new RawFile(file.externalPath().orElse(bucketPath + "/" + file.fileName()), file.fileSize(), 0L, file.fileSize(), file.fileFormat(), file.schemaId(), file.rowCount());
    }

    @Override
    @Nullable
    public Optional<List<IndexFile>> indexFiles() {
        ArrayList<IndexFile> indexFiles = new ArrayList<IndexFile>();
        boolean hasIndexFile = false;
        for (DataFileMeta file : this.dataFiles) {
            List exFiles = file.extraFiles().stream().filter(s -> s.endsWith(".index")).collect(Collectors.toList());
            if (exFiles.isEmpty()) {
                indexFiles.add(null);
                continue;
            }
            if (exFiles.size() == 1) {
                hasIndexFile = true;
                indexFiles.add(new IndexFile(this.bucketPath + "/" + (String)exFiles.get(0)));
                continue;
            }
            throw new RuntimeException("Wrong number of file index for file " + file.fileName() + " index files: " + String.join((CharSequence)",", exFiles));
        }
        return hasIndexFile ? Optional.of(indexFiles) : Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSplit dataSplit = (DataSplit)o;
        return this.snapshotId == dataSplit.snapshotId && this.bucket == dataSplit.bucket && this.isStreaming == dataSplit.isStreaming && this.rawConvertible == dataSplit.rawConvertible && Objects.equals(this.partition, dataSplit.partition) && Objects.equals(this.bucketPath, dataSplit.bucketPath) && Objects.equals(this.totalBuckets, dataSplit.totalBuckets) && Objects.equals(this.beforeFiles, dataSplit.beforeFiles) && Objects.equals(this.beforeDeletionFiles, dataSplit.beforeDeletionFiles) && Objects.equals(this.dataFiles, dataSplit.dataFiles) && Objects.equals(this.dataDeletionFiles, dataSplit.dataDeletionFiles);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotId, this.partition, this.bucket, this.bucketPath, this.totalBuckets, this.beforeFiles, this.beforeDeletionFiles, this.dataFiles, this.dataDeletionFiles, this.isStreaming, this.rawConvertible);
    }

    public String toString() {
        return "{snapshotId=" + this.snapshotId + ", partition=hash-" + this.partition.hashCode() + ", bucket=" + this.bucket + ", rawConvertible=" + this.rawConvertible + '}' + "@" + Integer.toHexString(this.hashCode());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serialize(new DataOutputViewStreamWrapper(out));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.assign(DataSplit.deserialize(new DataInputViewStreamWrapper(in)));
    }

    protected void assign(DataSplit other) {
        this.snapshotId = other.snapshotId;
        this.partition = other.partition;
        this.bucket = other.bucket;
        this.bucketPath = other.bucketPath;
        this.totalBuckets = other.totalBuckets;
        this.beforeFiles = other.beforeFiles;
        this.beforeDeletionFiles = other.beforeDeletionFiles;
        this.dataFiles = other.dataFiles;
        this.dataDeletionFiles = other.dataDeletionFiles;
        this.isStreaming = other.isStreaming;
        this.rawConvertible = other.rawConvertible;
    }

    public void serialize(DataOutputView out) throws IOException {
        out.writeLong(-2394839472490812314L);
        out.writeInt(8);
        out.writeLong(this.snapshotId);
        SerializationUtils.serializeBinaryRow(this.partition, out);
        out.writeInt(this.bucket);
        out.writeUTF(this.bucketPath);
        if (this.totalBuckets != null) {
            out.writeBoolean(true);
            out.writeInt(this.totalBuckets);
        } else {
            out.writeBoolean(false);
        }
        DataFileMetaSerializer dataFileSer = new DataFileMetaSerializer();
        out.writeInt(this.beforeFiles.size());
        for (DataFileMeta file : this.beforeFiles) {
            dataFileSer.serialize(file, out);
        }
        DeletionFile.serializeList(out, this.beforeDeletionFiles);
        out.writeInt(this.dataFiles.size());
        for (DataFileMeta file : this.dataFiles) {
            dataFileSer.serialize(file, out);
        }
        DeletionFile.serializeList(out, this.dataDeletionFiles);
        out.writeBoolean(this.isStreaming);
        out.writeBoolean(this.rawConvertible);
    }

    public static DataSplit deserialize(DataInputView in) throws IOException {
        long magic = in.readLong();
        int version = magic == -2394839472490812314L ? in.readInt() : 1;
        long snapshotId = version == 1 ? magic : in.readLong();
        BinaryRow partition = SerializationUtils.deserializeBinaryRow(in);
        int bucket = in.readInt();
        String bucketPath = in.readUTF();
        Integer totalBuckets = version >= 6 && in.readBoolean() ? Integer.valueOf(in.readInt()) : null;
        FunctionWithIOException<DataInputView, DataFileMeta> dataFileSer = DataSplit.getFileMetaSerde(version);
        FunctionWithIOException<DataInputView, DeletionFile> deletionFileSerde = DataSplit.getDeletionFileSerde(version);
        int beforeNumber = in.readInt();
        ArrayList<DataFileMeta> beforeFiles = new ArrayList<DataFileMeta>(beforeNumber);
        for (int i = 0; i < beforeNumber; ++i) {
            beforeFiles.add((DataFileMeta)dataFileSer.apply(in));
        }
        List<DeletionFile> beforeDeletionFiles = DeletionFile.deserializeList(in, deletionFileSerde);
        int fileNumber = in.readInt();
        ArrayList<DataFileMeta> dataFiles = new ArrayList<DataFileMeta>(fileNumber);
        for (int i = 0; i < fileNumber; ++i) {
            dataFiles.add((DataFileMeta)dataFileSer.apply(in));
        }
        List<DeletionFile> dataDeletionFiles = DeletionFile.deserializeList(in, deletionFileSerde);
        boolean isStreaming = in.readBoolean();
        boolean rawConvertible = in.readBoolean();
        Builder builder = DataSplit.builder().withSnapshot(snapshotId).withPartition(partition).withBucket(bucket).withBucketPath(bucketPath).withTotalBuckets(totalBuckets).withBeforeFiles(beforeFiles).withDataFiles(dataFiles).isStreaming(isStreaming).rawConvertible(rawConvertible);
        if (beforeDeletionFiles != null) {
            builder.withBeforeDeletionFiles(beforeDeletionFiles);
        }
        if (dataDeletionFiles != null) {
            builder.withDataDeletionFiles(dataDeletionFiles);
        }
        return builder.build();
    }

    private static FunctionWithIOException<DataInputView, DataFileMeta> getFileMetaSerde(int version) {
        if (version == 1) {
            DataFileMeta08Serializer serializer = new DataFileMeta08Serializer();
            return serializer::deserialize;
        }
        if (version == 2) {
            DataFileMeta09Serializer serializer = new DataFileMeta09Serializer();
            return serializer::deserialize;
        }
        if (version == 3 || version == 4) {
            DataFileMeta10LegacySerializer serializer = new DataFileMeta10LegacySerializer();
            return serializer::deserialize;
        }
        if (version == 5 || version == 6) {
            DataFileMeta12LegacySerializer serializer = new DataFileMeta12LegacySerializer();
            return serializer::deserialize;
        }
        if (version == 7) {
            DataFileMetaFirstRowIdLegacySerializer serializer = new DataFileMetaFirstRowIdLegacySerializer();
            return serializer::deserialize;
        }
        if (version == 8) {
            DataFileMetaSerializer serializer = new DataFileMetaSerializer();
            return serializer::deserialize;
        }
        throw new UnsupportedOperationException("Unsupported version: " + version);
    }

    private static FunctionWithIOException<DataInputView, DeletionFile> getDeletionFileSerde(int version) {
        if (version >= 1 && version <= 3) {
            return DeletionFile::deserializeV3;
        }
        if (version >= 4) {
            return DeletionFile::deserialize;
        }
        throw new UnsupportedOperationException("Unsupported version: " + version);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final DataSplit split = new DataSplit();

        public Builder withSnapshot(long snapshot) {
            this.split.snapshotId = snapshot;
            return this;
        }

        public Builder withPartition(BinaryRow partition) {
            this.split.partition = partition;
            return this;
        }

        public Builder withBucket(int bucket) {
            this.split.bucket = bucket;
            return this;
        }

        public Builder withBucketPath(String bucketPath) {
            this.split.bucketPath = bucketPath;
            return this;
        }

        public Builder withTotalBuckets(Integer totalBuckets) {
            this.split.totalBuckets = totalBuckets;
            return this;
        }

        public Builder withBeforeFiles(List<DataFileMeta> beforeFiles) {
            this.split.beforeFiles = new ArrayList<DataFileMeta>(beforeFiles);
            return this;
        }

        public Builder withBeforeDeletionFiles(List<DeletionFile> beforeDeletionFiles) {
            this.split.beforeDeletionFiles = new ArrayList<DeletionFile>(beforeDeletionFiles);
            return this;
        }

        public Builder withDataFiles(List<DataFileMeta> dataFiles) {
            this.split.dataFiles = new ArrayList<DataFileMeta>(dataFiles);
            return this;
        }

        public Builder withDataDeletionFiles(List<DeletionFile> dataDeletionFiles) {
            this.split.dataDeletionFiles = new ArrayList<DeletionFile>(dataDeletionFiles);
            return this;
        }

        public Builder isStreaming(boolean isStreaming) {
            this.split.isStreaming = isStreaming;
            return this;
        }

        public Builder rawConvertible(boolean rawConvertible) {
            this.split.rawConvertible = rawConvertible;
            return this;
        }

        public DataSplit build() {
            Preconditions.checkArgument(this.split.partition != null);
            Preconditions.checkArgument(this.split.bucket != -1);
            Preconditions.checkArgument(this.split.bucketPath != null);
            Preconditions.checkArgument(this.split.dataFiles != null);
            DataSplit split = new DataSplit();
            split.assign(this.split);
            return split;
        }
    }
}

