/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.Snapshot;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMetaSerializer;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.table.source.snapshot.TimeTravelUtil;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableIndexesTable
implements ReadonlyTable {
    private static final Logger LOG = LoggerFactory.getLogger(TableIndexesTable.class);
    public static final String TABLE_INDEXES = "table_indexes";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "partition", SerializationUtils.newStringType(true)), new DataField(1, "bucket", new IntType(false)), new DataField(2, "index_type", SerializationUtils.newStringType(false)), new DataField(3, "file_name", SerializationUtils.newStringType(false)), new DataField(4, "file_size", new BigIntType(false)), new DataField(5, "row_count", new BigIntType(false)), new DataField(6, "dv_ranges", new ArrayType(true, DeletionVectorMeta.SCHEMA))));
    private final FileStoreTable dataTable;

    public TableIndexesTable(FileStoreTable dataTable) {
        this.dataTable = dataTable;
    }

    @Override
    public InnerTableScan newScan() {
        return new IndexesScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new IndexesRead(this.dataTable);
    }

    @Override
    public String name() {
        return this.dataTable.name() + "$" + TABLE_INDEXES;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("file_name");
    }

    @Override
    public FileIO fileIO() {
        return this.dataTable.fileIO();
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new TableIndexesTable((FileStoreTable)this.dataTable.copy((Map)dynamicOptions));
    }

    private static List<IndexManifestEntry> allIndexEntries(FileStoreTable dataTable) {
        IndexFileHandler indexFileHandler = dataTable.store().newIndexFileHandler();
        Snapshot snapshot = TimeTravelUtil.tryTravelOrLatest(dataTable);
        if (snapshot == null) {
            LOG.warn("Check if your snapshot is empty.");
            return Collections.emptyList();
        }
        String indexManifest = snapshot.indexManifest();
        if (indexManifest == null || !indexFileHandler.existsManifest(indexManifest)) {
            LOG.warn("indexManifest doesn't exist.");
            return Collections.emptyList();
        }
        return indexFileHandler.readManifest(indexManifest);
    }

    private static class IndexesRead
    implements InnerTableRead {
        private RowType readType;
        private final FileStoreTable dataTable;

        public IndexesRead(FileStoreTable dataTable) {
            this.dataTable = dataTable;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof IndexesSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            List manifestFileMetas = TableIndexesTable.allIndexEntries(this.dataTable);
            CastExecutor<?, ?> partitionCastExecutor = CastExecutors.resolveToString(this.dataTable.schema().logicalPartitionType());
            Iterator rows = Iterators.transform(manifestFileMetas.iterator(), indexManifestEntry -> this.toRow((IndexManifestEntry)indexManifestEntry, (CastExecutor<InternalRow, BinaryString>)partitionCastExecutor));
            if (this.readType != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.readType, TABLE_TYPE).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow toRow(IndexManifestEntry indexManifestEntry, CastExecutor<InternalRow, BinaryString> partitionCastExecutor) {
            LinkedHashMap<String, DeletionVectorMeta> dvMetas = indexManifestEntry.indexFile().dvRanges();
            return GenericRow.of(partitionCastExecutor.cast(indexManifestEntry.partition()), indexManifestEntry.bucket(), BinaryString.fromString(indexManifestEntry.indexFile().indexType()), BinaryString.fromString(indexManifestEntry.indexFile().fileName()), indexManifestEntry.indexFile().fileSize(), indexManifestEntry.indexFile().rowCount(), dvMetas == null ? null : IndexFileMetaSerializer.dvMetasToRowArrayData(dvMetas.values()));
        }
    }

    private static class IndexesSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;

        private IndexesSplit() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }

    private static class IndexesScan
    extends ReadOnceTableScan {
        private IndexesScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        protected TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new IndexesSplit());
        }
    }
}

