/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Segments;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.operation.metrics.CacheMetrics;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BiFunctionWithIOE;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.FunctionWithIOException;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.ObjectsFile;
import org.apache.paimon.utils.SegmentsCache;

@ThreadSafe
public abstract class ObjectsCache<K, V, S extends Segments> {
    protected final SegmentsCache<K> cache;
    protected final ObjectSerializer<V> projectedSerializer;
    protected final ThreadLocal<InternalRowSerializer> formatSerializer;
    protected final FunctionWithIOException<K, Long> fileSizeFunction;
    protected final BiFunctionWithIOE<K, Long, CloseableIterator<InternalRow>> reader;
    @Nullable
    protected CacheMetrics cacheMetrics;

    protected ObjectsCache(SegmentsCache<K> cache, ObjectSerializer<V> projectedSerializer, RowType formatSchema, FunctionWithIOException<K, Long> fileSizeFunction, BiFunctionWithIOE<K, Long, CloseableIterator<InternalRow>> reader) {
        this.cache = cache;
        this.projectedSerializer = projectedSerializer;
        this.formatSerializer = ThreadLocal.withInitial(() -> new InternalRowSerializer(formatSchema));
        this.fileSizeFunction = fileSizeFunction;
        this.reader = reader;
    }

    public void withCacheMetrics(@Nullable CacheMetrics cacheMetrics) {
        this.cacheMetrics = cacheMetrics;
    }

    public List<V> read(K key, @Nullable Long fileSize, Filters<V> filters) throws IOException {
        Segments segments = this.cache.getIfPresents(key);
        if (segments != null) {
            if (this.cacheMetrics != null) {
                this.cacheMetrics.increaseHitObject();
            }
            return this.readFromSegments(segments, filters);
        }
        if (this.cacheMetrics != null) {
            this.cacheMetrics.increaseMissedObject();
        }
        if (fileSize == null) {
            fileSize = (Long)this.fileSizeFunction.apply(key);
        }
        if (fileSize <= this.cache.maxElementSize()) {
            segments = this.createSegments(key, fileSize);
            this.cache.put(key, segments);
            return this.readFromSegments(segments, filters);
        }
        return ObjectsFile.readFromIterator(this.reader.apply(key, fileSize), this.projectedSerializer, filters.readFilter(), filters.readVFilter());
    }

    protected abstract List<V> readFromSegments(S var1, Filters<V> var2) throws IOException;

    protected abstract S createSegments(K var1, @Nullable Long var2);

    public static class Filters<V> {
        private final Filter<InternalRow> readFilter;
        private final Filter<V> readVFilter;

        public Filters(Filter<InternalRow> readFilter, Filter<V> readVFilter) {
            this.readFilter = readFilter;
            this.readVFilter = readVFilter;
        }

        public Filter<InternalRow> readFilter() {
            return this.readFilter;
        }

        public Filter<V> readVFilter() {
            return this.readVFilter;
        }
    }
}

