/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.StringUtils;

class StringToRowCastRule
extends AbstractCastRule<BinaryString, InternalRow> {
    static final StringToRowCastRule INSTANCE = new StringToRowCastRule();
    private static final Pattern BRACKET_ROW_PATTERN = Pattern.compile("^\\s*\\{(.*)\\}\\s*$");
    private static final Pattern FUNCTION_ROW_PATTERN = Pattern.compile("^\\s*STRUCT\\s*\\((.*)\\)\\s*$", 2);

    private StringToRowCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.CHARACTER_STRING).target(DataTypeRoot.ROW).build());
    }

    @Override
    public CastExecutor<BinaryString, InternalRow> create(DataType inputType, DataType targetType) {
        RowType rowType = (RowType)targetType;
        CastExecutor[] fieldCastExecutors = this.createFieldCastExecutors(rowType);
        return value -> this.parseRow((BinaryString)value, fieldCastExecutors, rowType.getFieldCount());
    }

    private CastExecutor<BinaryString, Object>[] createFieldCastExecutors(RowType rowType) {
        int fieldCount = rowType.getFieldCount();
        CastExecutor[] fieldCastExecutors = new CastExecutor[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            DataType fieldType = rowType.getTypeAt(i);
            CastExecutor<?, ?> executor = CastExecutors.resolve(VarCharType.STRING_TYPE, fieldType);
            if (executor == null) {
                throw new RuntimeException("Cannot cast string to row field type: " + fieldType);
            }
            fieldCastExecutors[i] = executor;
        }
        return fieldCastExecutors;
    }

    private InternalRow parseRow(BinaryString value, CastExecutor<BinaryString, Object>[] fieldCastExecutors, int fieldCount) {
        try {
            String str = value.toString().trim();
            if ("{}".equals(str) || "STRUCT()".equalsIgnoreCase(str)) {
                return this.createNullRow(fieldCount);
            }
            String content = this.extractRowContent(str);
            if (content.isEmpty()) {
                return this.createNullRow(fieldCount);
            }
            List<String> fieldValues = this.splitRowFields(content);
            if (fieldValues.size() != fieldCount) {
                throw new RuntimeException("Row field count mismatch. Expected: " + fieldCount + ", Actual: " + fieldValues.size());
            }
            return this.createRowFromFields(fieldValues, fieldCastExecutors, fieldCount);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse '" + value + "' as ROW: " + e.getMessage(), e);
        }
    }

    private String extractRowContent(String str) {
        Matcher bracketMatcher = BRACKET_ROW_PATTERN.matcher(str);
        if (bracketMatcher.matches()) {
            return bracketMatcher.group(1).trim();
        }
        Matcher functionMatcher = FUNCTION_ROW_PATTERN.matcher(str);
        if (functionMatcher.matches()) {
            return functionMatcher.group(1).trim();
        }
        throw new RuntimeException("Invalid row format: " + str + ". Expected format: {f1, f2} or STRUCT(f1, f2)");
    }

    private GenericRow createNullRow(int fieldCount) {
        GenericRow row = new GenericRow(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            row.setField(i, null);
        }
        return row;
    }

    private GenericRow createRowFromFields(List<String> fieldValues, CastExecutor<BinaryString, Object>[] fieldCastExecutors, int fieldCount) {
        GenericRow row = new GenericRow(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            String fieldValue = fieldValues.get(i).trim();
            Object value = this.parseFieldValue(fieldValue, fieldCastExecutors[i]);
            row.setField(i, value);
        }
        return row;
    }

    private Object parseFieldValue(String fieldValue, CastExecutor<BinaryString, Object> castExecutor) {
        return "null".equals(fieldValue) ? null : castExecutor.cast(BinaryString.fromString(fieldValue));
    }

    private List<String> splitRowFields(String content) {
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        Stack<Character> bracketStack = new Stack<Character>();
        boolean inQuotes = false;
        boolean escaped = false;
        for (char c : content.toCharArray()) {
            if (escaped) {
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else if (c == '\"') {
                inQuotes = !inQuotes;
            } else if (!inQuotes) {
                if (StringUtils.isOpenBracket(c)) {
                    bracketStack.push(Character.valueOf(c));
                } else if (StringUtils.isCloseBracket(c) && !bracketStack.isEmpty()) {
                    bracketStack.pop();
                } else if (c == ',' && bracketStack.isEmpty()) {
                    this.addCurrentField(fields, current);
                    continue;
                }
            }
            current.append(c);
        }
        this.addCurrentField(fields, current);
        return fields;
    }

    private void addCurrentField(List<String> fields, StringBuilder current) {
        if (current.length() > 0) {
            fields.add(current.toString());
            current.setLength(0);
        }
    }
}

