/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.util.CollectionUtil;
import org.apache.paimon.utils.Pair;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDbPointer;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class BsonValueConvertor {
    private static Integer convert(BsonTimestamp bsonTimestamp) {
        return bsonTimestamp.getTime();
    }

    private static Number convert(BsonDecimal128 bsonValue) {
        return BsonValueConvertor.convert(bsonValue.decimal128Value());
    }

    private static Number convert(Decimal128 bsonValue) {
        if (bsonValue.isNaN()) {
            return Double.NaN;
        }
        if (bsonValue.isInfinite()) {
            if (bsonValue.isNegative()) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        return bsonValue.bigDecimalValue();
    }

    private static String convert(BsonObjectId objectId) {
        return BsonValueConvertor.convert(objectId.getValue());
    }

    private static String convert(ObjectId objectId) {
        return objectId.toHexString();
    }

    private static String convert(BsonBinary bsonBinary) {
        if (BsonBinarySubType.isUuid((byte)bsonBinary.getType())) {
            return bsonBinary.asUuid().toString();
        }
        return Base64.getEncoder().encodeToString(bsonBinary.getData());
    }

    private static String convert(BsonUndefined bsonUndefined) {
        return null;
    }

    private static String convert(BsonRegularExpression regex) {
        String escaped = regex.getPattern().isEmpty() ? "(?:)" : regex.getPattern().replace("/", "\\/");
        return String.format("/%s/%s", escaped, regex.getOptions());
    }

    private static Double convert(BsonDouble bsonDouble) {
        return bsonDouble.getValue();
    }

    private static String convert(BsonString string) {
        return string.getValue();
    }

    private static Integer convert(BsonInt32 int32) {
        return int32.getValue();
    }

    private static Long convert(BsonInt64 int64) {
        return int64.getValue();
    }

    private static Boolean convert(BsonBoolean bool) {
        return bool.getValue();
    }

    private static Long convert(BsonDateTime dateTime) {
        return dateTime.getValue();
    }

    private static String convert(BsonSymbol symbol) {
        return symbol.getSymbol();
    }

    private static String convert(BsonJavaScript javascript) {
        return javascript.getCode();
    }

    private static Map<String, Object> convert(BsonJavaScriptWithScope javascriptWithScope) {
        return CollectionUtil.map((Map.Entry[])new Map.Entry[]{Pair.of("$code", javascriptWithScope.getCode()), Pair.of("$scope", BsonValueConvertor.convert(javascriptWithScope.getScope()))});
    }

    private static String convert(BsonNull bsonNull) {
        return null;
    }

    private static String convert(BsonDbPointer dbPointer) {
        return dbPointer.toString();
    }

    private static String convert(BsonMaxKey maxKey) {
        return maxKey.toString();
    }

    private static String convert(BsonMinKey minKey) {
        return minKey.toString();
    }

    private static Map<String, Object> convert(BsonDocument document) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(document.size());
        for (Map.Entry entry : document.entrySet()) {
            map.put((String)entry.getKey(), BsonValueConvertor.convert((BsonValue)entry.getValue()));
        }
        return map;
    }

    private static List<Object> convert(BsonArray array) {
        ArrayList<Object> objects = new ArrayList<Object>(array.size());
        for (BsonValue bsonValue : array) {
            objects.add(BsonValueConvertor.convert(bsonValue));
        }
        return objects;
    }

    public static Object convert(BsonValue bsonValue) {
        if (bsonValue == null) {
            return null;
        }
        switch (bsonValue.getBsonType()) {
            case TIMESTAMP: {
                return BsonValueConvertor.convert(bsonValue.asTimestamp());
            }
            case DECIMAL128: {
                return BsonValueConvertor.convert(bsonValue.asDecimal128());
            }
            case OBJECT_ID: {
                return BsonValueConvertor.convert(bsonValue.asObjectId());
            }
            case BINARY: {
                return BsonValueConvertor.convert(bsonValue.asBinary());
            }
            case UNDEFINED: {
                return BsonValueConvertor.convert((BsonUndefined)bsonValue);
            }
            case REGULAR_EXPRESSION: {
                return BsonValueConvertor.convert(bsonValue.asRegularExpression());
            }
            case DOUBLE: {
                return BsonValueConvertor.convert(bsonValue.asDouble());
            }
            case STRING: {
                return BsonValueConvertor.convert(bsonValue.asString());
            }
            case INT32: {
                return BsonValueConvertor.convert(bsonValue.asInt32());
            }
            case INT64: {
                return BsonValueConvertor.convert(bsonValue.asInt64());
            }
            case BOOLEAN: {
                return BsonValueConvertor.convert(bsonValue.asBoolean());
            }
            case DATE_TIME: {
                return BsonValueConvertor.convert(bsonValue.asDateTime());
            }
            case SYMBOL: {
                return BsonValueConvertor.convert(bsonValue.asSymbol());
            }
            case JAVASCRIPT: {
                return BsonValueConvertor.convert(bsonValue.asJavaScript());
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return BsonValueConvertor.convert(bsonValue.asJavaScriptWithScope());
            }
            case NULL: {
                return BsonValueConvertor.convert((BsonNull)bsonValue);
            }
            case DB_POINTER: {
                return BsonValueConvertor.convert(bsonValue.asDBPointer());
            }
            case MAX_KEY: {
                return BsonValueConvertor.convert((BsonMaxKey)bsonValue);
            }
            case MIN_KEY: {
                return BsonValueConvertor.convert((BsonMinKey)bsonValue);
            }
            case DOCUMENT: {
                return BsonValueConvertor.convert(bsonValue.asDocument());
            }
            case ARRAY: {
                return BsonValueConvertor.convert(bsonValue.asArray());
            }
        }
        throw new IllegalArgumentException("Unsupported BSON type: " + bsonValue.getBsonType());
    }
}

