/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.clone.files;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.FlinkCatalogFactory;
import org.apache.paimon.flink.clone.CloneHiveTableUtils;
import org.apache.paimon.hive.HiveCatalog;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CloneFilesProcessFunction<I, O>
extends ProcessFunction<I, O> {
    protected static final Logger LOG = LoggerFactory.getLogger(CloneFilesProcessFunction.class);
    protected final Map<String, String> sourceCatalogConfig;
    protected final Map<String, String> targetCatalogConfig;
    protected transient HiveCatalog hiveCatalog;
    protected transient Catalog targetCatalog;
    protected transient Map<Identifier, Table> tableCache;
    protected transient DataFileMetaSerializer dataFileSerializer;

    public CloneFilesProcessFunction(Map<String, String> sourceCatalogConfig, Map<String, String> targetCatalogConfig) {
        this.sourceCatalogConfig = sourceCatalogConfig;
        this.targetCatalogConfig = targetCatalogConfig;
    }

    public void open(OpenContext openContext) throws Exception {
        this.open(new Configuration());
    }

    public void open(Configuration conf) throws Exception {
        this.hiveCatalog = CloneHiveTableUtils.getRootHiveCatalog(FlinkCatalogFactory.createPaimonCatalog(Options.fromMap(this.sourceCatalogConfig)));
        this.targetCatalog = FlinkCatalogFactory.createPaimonCatalog(Options.fromMap(this.targetCatalogConfig));
        this.dataFileSerializer = new DataFileMetaSerializer();
        this.tableCache = new HashMap<Identifier, Table>();
    }

    protected Table getTable(Identifier identifier) {
        return this.tableCache.computeIfAbsent(identifier, k -> {
            try {
                return this.targetCatalog.getTable((Identifier)k);
            }
            catch (Catalog.TableNotExistException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void close() throws Exception {
        super.close();
        if (this.hiveCatalog != null) {
            this.hiveCatalog.close();
        }
        if (this.targetCatalog != null) {
            this.targetCatalog.close();
        }
    }
}

