/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.lookup.PartitionLoader;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicPartitionLoader
extends PartitionLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicPartitionLoader.class);
    private static final long serialVersionUID = 3L;
    protected final Duration refreshInterval;
    protected transient Comparator<InternalRow> comparator;
    protected transient LocalDateTime lastRefresh;

    DynamicPartitionLoader(FileStoreTable table, Duration refreshInterval) {
        super(table);
        this.refreshInterval = refreshInterval;
    }

    @Override
    public void open() {
        super.open();
        RowType partitionType = this.table.rowType().project(this.table.partitionKeys());
        this.comparator = CodeGenUtils.newRecordComparator(partitionType.getFieldTypes());
        this.lastRefresh = null;
    }

    @Override
    public boolean checkRefresh() {
        if (this.lastRefresh != null && !this.lastRefresh.plus(this.refreshInterval).isBefore(LocalDateTime.now())) {
            return false;
        }
        LOG.info("DynamicPartitionLoader(table={}) refreshed after {} second(s), refreshing", (Object)this.table.name(), (Object)(this.refreshInterval.toMillis() / 1000L));
        List<BinaryRow> newPartitions = this.getMaxPartitions();
        this.lastRefresh = LocalDateTime.now();
        if (newPartitions.size() != this.partitions.size()) {
            this.partitions = newPartitions;
            this.logNewPartitions();
            return true;
        }
        for (int i = 0; i < newPartitions.size(); ++i) {
            if (this.comparator.compare(newPartitions.get(i), (InternalRow)this.partitions.get(i)) == 0) continue;
            this.partitions = newPartitions;
            this.logNewPartitions();
            return true;
        }
        LOG.info("DynamicPartitionLoader(table={}) didn't find new partitions.", (Object)this.table.name());
        return false;
    }

    protected abstract List<BinaryRow> getMaxPartitions();

    private void logNewPartitions() {
        String partitionsStr = this.partitionsToString(this.partitions);
        LOG.info("DynamicPartitionLoader(table={}) finds new partitions: {}.", (Object)this.table.name(), (Object)partitionsStr);
    }

    protected String partitionsToString(List<BinaryRow> partitions) {
        return partitions.stream().map(partition -> InternalRowPartitionComputer.partToSimpleString(this.table.rowType().project(this.table.partitionKeys()), partition, "-", 200)).collect(Collectors.joining(","));
    }
}

