/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup.partitioner;

import org.apache.flink.table.connector.source.abilities.SupportsLookupCustomShuffle;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.MathUtils;
import org.apache.paimon.flink.lookup.partitioner.BucketIdExtractor;
import org.apache.paimon.flink.lookup.partitioner.ShuffleStrategy;

public class BucketShufflePartitioner
implements SupportsLookupCustomShuffle.InputDataPartitioner {
    private final ShuffleStrategy strategy;
    private final BucketIdExtractor extractor;

    public BucketShufflePartitioner(ShuffleStrategy strategy, BucketIdExtractor extractor) {
        this.strategy = strategy;
        this.extractor = extractor;
    }

    @Override
    public int partition(RowData joinKeys, int numPartitions) {
        int bucketId = this.extractor.extractBucketId(joinKeys);
        int joinKeyHash = MathUtils.murmurHash((int)joinKeys.hashCode());
        return this.strategy.getTargetSubtaskId(bucketId, joinKeyHash, numPartitions);
    }
}

