/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.format.SimpleStatsCollector;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.iceberg.IcebergOptions;
import org.apache.paimon.iceberg.IcebergPathFactory;
import org.apache.paimon.iceberg.manifest.IcebergConversions;
import org.apache.paimon.iceberg.manifest.IcebergManifestEntry;
import org.apache.paimon.iceberg.manifest.IcebergManifestEntrySerializer;
import org.apache.paimon.iceberg.manifest.IcebergManifestFileMeta;
import org.apache.paimon.iceberg.manifest.IcebergPartitionSummary;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.io.SingleFileWriter;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.ObjectsFile;
import org.apache.paimon.utils.PathFactory;

public class IcebergManifestFile
extends ObjectsFile<IcebergManifestEntry> {
    private static final long UNASSIGNED_SEQ = -1L;
    private final RowType partitionType;
    private final FormatWriterFactory writerFactory;
    private final MemorySize targetFileSize;

    public IcebergManifestFile(FileIO fileIO, RowType partitionType, FormatReaderFactory readerFactory, FormatWriterFactory writerFactory, String compression, PathFactory pathFactory, MemorySize targetFileSize) {
        super(fileIO, new IcebergManifestEntrySerializer(partitionType), IcebergManifestEntry.schema(partitionType), readerFactory, writerFactory, compression, pathFactory, null);
        this.partitionType = partitionType;
        this.writerFactory = writerFactory;
        this.targetFileSize = targetFileSize;
    }

    @VisibleForTesting
    public String compression() {
        return this.compression;
    }

    public static IcebergManifestFile create(FileStoreTable table, IcebergPathFactory pathFactory) {
        RowType partitionType = table.schema().logicalPartitionType();
        RowType entryType = IcebergManifestEntry.schema(partitionType);
        Options avroOptions = Options.fromMap(table.options());
        avroOptions.set("avro.row-name-mapping", "org.apache.paimon.avro.generated.record:manifest_entry,iceberg:true,manifest_entry_data_file:r2,r2_partition:r102,kv_name_r2_null_value_counts:k121_v122,k_id_k121_v122:121,v_id_k121_v122:122,kv_name_r2_lower_bounds:k126_v127,k_id_k126_v127:126,v_id_k126_v127:127,kv_name_r2_upper_bounds:k129_v130,k_id_k129_v130:129,v_id_k129_v130:130");
        FileFormat manifestFileAvro = FileFormat.fromIdentifier("avro", avroOptions);
        return new IcebergManifestFile(table.fileIO(), partitionType, manifestFileAvro.createReaderFactory(entryType, entryType, new ArrayList<Predicate>()), manifestFileAvro.createWriterFactory(entryType), avroOptions.get(IcebergOptions.MANIFEST_COMPRESSION), pathFactory.manifestFileFactory(), table.coreOptions().manifestTargetSize());
    }

    public List<IcebergManifestEntry> read(IcebergManifestFileMeta meta) {
        return this.read(meta, null);
    }

    public List<IcebergManifestEntry> read(IcebergManifestFileMeta meta, @Nullable Long fileSize) {
        String fileName = new Path(meta.manifestPath()).getName();
        try {
            Path path = this.pathFactory.toPath(fileName);
            return IcebergManifestFile.readFromIterator(meta, this.createIterator(path, fileSize), (IcebergManifestEntrySerializer)this.serializer, Filter.alwaysTrue());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + fileName, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<IcebergManifestEntry> readFromIterator(IcebergManifestFileMeta meta, CloseableIterator<InternalRow> inputIterator, IcebergManifestEntrySerializer serializer, Filter<InternalRow> readFilter) {
        try (CloseableIterator<InternalRow> iterator = inputIterator;){
            ArrayList<IcebergManifestEntry> result = new ArrayList<IcebergManifestEntry>();
            while (iterator.hasNext()) {
                InternalRow row = (InternalRow)iterator.next();
                if (!readFilter.test(row)) continue;
                result.add(serializer.fromRow(row, meta));
            }
            ArrayList<IcebergManifestEntry> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<IcebergManifestFileMeta> rollingWrite(Iterator<IcebergManifestEntry> entries, long sequenceNumber) {
        return this.rollingWrite(entries, sequenceNumber, IcebergManifestFileMeta.Content.DATA);
    }

    public List<IcebergManifestFileMeta> rollingWrite(Iterator<IcebergManifestEntry> entries, long sequenceNumber, IcebergManifestFileMeta.Content content) {
        RollingFileWriter writer = new RollingFileWriter(() -> this.createWriter(sequenceNumber, content), this.targetFileSize.getBytes());
        try {
            writer.write(entries);
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return writer.result();
    }

    public SingleFileWriter<IcebergManifestEntry, IcebergManifestFileMeta> createWriter(long sequenceNumber, IcebergManifestFileMeta.Content content) {
        return new IcebergManifestEntryWriter(this.writerFactory, this.pathFactory.newPath(), this.compression, sequenceNumber, content);
    }

    private class IcebergManifestEntryWriter
    extends SingleFileWriter<IcebergManifestEntry, IcebergManifestFileMeta> {
        private final SimpleStatsCollector partitionStatsCollector;
        private final long sequenceNumber;
        private int addedFilesCount;
        private int existingFilesCount;
        private int deletedFilesCount;
        private long addedRowsCount;
        private long existingRowsCount;
        private long deletedRowsCount;
        private Long minSequenceNumber;
        private final IcebergManifestFileMeta.Content content;

        IcebergManifestEntryWriter(FormatWriterFactory factory, Path path, String fileCompression, long sequenceNumber, IcebergManifestFileMeta.Content content) {
            super(IcebergManifestFile.this.fileIO, factory, path, IcebergManifestFile.this.serializer::toRow, fileCompression, false);
            this.addedFilesCount = 0;
            this.existingFilesCount = 0;
            this.deletedFilesCount = 0;
            this.addedRowsCount = 0L;
            this.existingRowsCount = 0L;
            this.deletedRowsCount = 0L;
            this.minSequenceNumber = null;
            this.partitionStatsCollector = new SimpleStatsCollector(IcebergManifestFile.this.partitionType);
            this.sequenceNumber = sequenceNumber;
            this.content = content;
        }

        @Override
        public void write(IcebergManifestEntry entry) throws IOException {
            super.write(entry);
            switch (entry.status()) {
                case ADDED: {
                    ++this.addedFilesCount;
                    this.addedRowsCount += entry.file().recordCount();
                    break;
                }
                case EXISTING: {
                    ++this.existingFilesCount;
                    this.existingRowsCount += entry.file().recordCount();
                    break;
                }
                case DELETED: {
                    ++this.deletedFilesCount;
                    this.deletedRowsCount += entry.file().recordCount();
                }
            }
            if (this.minSequenceNumber == null || this.minSequenceNumber > entry.sequenceNumber()) {
                this.minSequenceNumber = entry.sequenceNumber();
            }
            this.partitionStatsCollector.collect(entry.file().partition());
        }

        @Override
        public IcebergManifestFileMeta result() {
            SimpleColStats[] stats = this.partitionStatsCollector.extract();
            ArrayList<IcebergPartitionSummary> partitionSummaries = new ArrayList<IcebergPartitionSummary>();
            for (int i = 0; i < stats.length; ++i) {
                SimpleColStats fieldStats = stats[i];
                DataType type = IcebergManifestFile.this.partitionType.getTypeAt(i);
                partitionSummaries.add(new IcebergPartitionSummary(Objects.requireNonNull(fieldStats.nullCount()) > 0L, false, IcebergConversions.toByteBuffer(type, fieldStats.min()).array(), IcebergConversions.toByteBuffer(type, fieldStats.max()).array()));
            }
            return new IcebergManifestFileMeta(this.path.toString(), this.outputBytes, 0, this.content, this.sequenceNumber, this.minSequenceNumber != null ? this.minSequenceNumber : -1L, this.sequenceNumber, this.addedFilesCount, this.existingFilesCount, this.deletedFilesCount, this.addedRowsCount, this.existingRowsCount, this.deletedRowsCount, partitionSummaries);
        }
    }
}

