/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.PojoDataFileMeta;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.utils.SerializationUtils;

@Public
public interface DataFileMeta {
    public static final RowType SCHEMA = new RowType(false, Arrays.asList(new DataField(0, "_FILE_NAME", SerializationUtils.newStringType(false)), new DataField(1, "_FILE_SIZE", new BigIntType(false)), new DataField(2, "_ROW_COUNT", new BigIntType(false)), new DataField(3, "_MIN_KEY", SerializationUtils.newBytesType(false)), new DataField(4, "_MAX_KEY", SerializationUtils.newBytesType(false)), new DataField(5, "_KEY_STATS", SimpleStats.SCHEMA), new DataField(6, "_VALUE_STATS", SimpleStats.SCHEMA), new DataField(7, "_MIN_SEQUENCE_NUMBER", new BigIntType(false)), new DataField(8, "_MAX_SEQUENCE_NUMBER", new BigIntType(false)), new DataField(9, "_SCHEMA_ID", new BigIntType(false)), new DataField(10, "_LEVEL", new IntType(false)), new DataField(11, "_EXTRA_FILES", new ArrayType(false, SerializationUtils.newStringType(false))), new DataField(12, "_CREATION_TIME", DataTypes.TIMESTAMP_MILLIS()), new DataField(13, "_DELETE_ROW_COUNT", new BigIntType(true)), new DataField(14, "_EMBEDDED_FILE_INDEX", SerializationUtils.newBytesType(true)), new DataField(15, "_FILE_SOURCE", new TinyIntType(true)), new DataField(16, "_VALUE_STATS_COLS", DataTypes.ARRAY(DataTypes.STRING().notNull())), new DataField(17, "_EXTERNAL_PATH", SerializationUtils.newStringType(true)), new DataField(18, "_FIRST_ROW_ID", new BigIntType(true)), new DataField(19, "_WRITE_COLS", new ArrayType(true, SerializationUtils.newStringType(false)))));
    public static final BinaryRow EMPTY_MIN_KEY = BinaryRow.EMPTY_ROW;
    public static final BinaryRow EMPTY_MAX_KEY = BinaryRow.EMPTY_ROW;
    public static final int DUMMY_LEVEL = 0;

    public static DataFileMeta forAppend(String fileName, long fileSize, long rowCount, SimpleStats rowStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, List<String> extraFiles, @Nullable byte[] embeddedIndex, @Nullable FileSource fileSource, @Nullable List<String> valueStatsCols, @Nullable String externalPath, @Nullable Long firstRowId, @Nullable List<String> writeCols) {
        return new PojoDataFileMeta(fileName, fileSize, rowCount, EMPTY_MIN_KEY, EMPTY_MAX_KEY, SimpleStats.EMPTY_STATS, rowStats, minSequenceNumber, maxSequenceNumber, schemaId, 0, extraFiles, Timestamp.fromLocalDateTime(LocalDateTime.now()).toMillisTimestamp(), 0L, embeddedIndex, fileSource, valueStatsCols, externalPath, firstRowId, writeCols);
    }

    public static DataFileMeta create(String fileName, long fileSize, long rowCount, BinaryRow minKey, BinaryRow maxKey, SimpleStats keyStats, SimpleStats valueStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, int level, List<String> extraFiles, @Nullable Long deleteRowCount, @Nullable byte[] embeddedIndex, @Nullable FileSource fileSource, @Nullable List<String> valueStatsCols, @Nullable String externalPath, @Nullable Long firstRowId, @Nullable List<String> writeCols) {
        return new PojoDataFileMeta(fileName, fileSize, rowCount, minKey, maxKey, keyStats, valueStats, minSequenceNumber, maxSequenceNumber, schemaId, level, extraFiles, Timestamp.fromLocalDateTime(LocalDateTime.now()).toMillisTimestamp(), deleteRowCount, embeddedIndex, fileSource, valueStatsCols, externalPath, firstRowId, writeCols);
    }

    public static DataFileMeta create(String fileName, long fileSize, long rowCount, BinaryRow minKey, BinaryRow maxKey, SimpleStats keyStats, SimpleStats valueStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, int level, @Nullable Long deleteRowCount, @Nullable byte[] embeddedIndex, @Nullable FileSource fileSource, @Nullable List<String> valueStatsCols, @Nullable Long firstRowId, @Nullable List<String> writeCols) {
        return new PojoDataFileMeta(fileName, fileSize, rowCount, minKey, maxKey, keyStats, valueStats, minSequenceNumber, maxSequenceNumber, schemaId, level, Collections.emptyList(), Timestamp.fromLocalDateTime(LocalDateTime.now()).toMillisTimestamp(), deleteRowCount, embeddedIndex, fileSource, valueStatsCols, null, firstRowId, writeCols);
    }

    public static DataFileMeta create(String fileName, long fileSize, long rowCount, BinaryRow minKey, BinaryRow maxKey, SimpleStats keyStats, SimpleStats valueStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, int level, List<String> extraFiles, Timestamp creationTime, @Nullable Long deleteRowCount, @Nullable byte[] embeddedIndex, @Nullable FileSource fileSource, @Nullable List<String> valueStatsCols, @Nullable String externalPath, @Nullable Long firstRowId, @Nullable List<String> writeCols) {
        return new PojoDataFileMeta(fileName, fileSize, rowCount, minKey, maxKey, keyStats, valueStats, minSequenceNumber, maxSequenceNumber, schemaId, level, extraFiles, creationTime, deleteRowCount, embeddedIndex, fileSource, valueStatsCols, externalPath, firstRowId, writeCols);
    }

    public String fileName();

    public long fileSize();

    public long rowCount();

    public Optional<Long> deleteRowCount();

    public byte[] embeddedIndex();

    public BinaryRow minKey();

    public BinaryRow maxKey();

    public SimpleStats keyStats();

    public SimpleStats valueStats();

    public long minSequenceNumber();

    public long maxSequenceNumber();

    public long schemaId();

    public int level();

    public List<String> extraFiles();

    public Timestamp creationTime();

    public long creationTimeEpochMillis();

    public String fileFormat();

    public Optional<String> externalPath();

    public Optional<String> externalPathDir();

    public Optional<FileSource> fileSource();

    @Nullable
    public List<String> valueStatsCols();

    @Nullable
    public Long firstRowId();

    @Nullable
    public List<String> writeCols();

    public DataFileMeta upgrade(int var1);

    public DataFileMeta rename(String var1);

    public DataFileMeta copyWithoutStats();

    public DataFileMeta assignSequenceNumber(long var1, long var3);

    public DataFileMeta assignFirstRowId(long var1);

    default public List<Path> collectFiles(DataFilePathFactory pathFactory) {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(pathFactory.toPath(this));
        this.extraFiles().forEach(f -> paths.add(pathFactory.toAlignedPath((String)f, this)));
        return paths;
    }

    public DataFileMeta copy(List<String> var1);

    public DataFileMeta newExternalPath(String var1);

    public DataFileMeta copy(byte[] var1);

    public static long getMaxSequenceNumber(List<DataFileMeta> fileMetas) {
        return fileMetas.stream().map(DataFileMeta::maxSequenceNumber).max(Long::compare).orElse(-1L);
    }
}

