/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.lookup.LookupStoreReader;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.utils.FileIOUtils;

public class DataFileReader
implements Closeable {
    private final File localFile;
    private final DataFileMeta remoteFile;
    private final LookupStoreReader reader;

    public DataFileReader(File localFile, DataFileMeta remoteFile, LookupStoreReader reader) {
        this.localFile = localFile;
        this.remoteFile = remoteFile;
        this.reader = reader;
    }

    @Nullable
    public byte[] get(byte[] key) throws IOException {
        return this.reader.lookup(key);
    }

    public int fileKibiBytes() {
        long kibiBytes = this.localFile.length() >> 10;
        if (kibiBytes > Integer.MAX_VALUE) {
            throw new RuntimeException("Lookup file is too big: " + MemorySize.ofKibiBytes(kibiBytes));
        }
        return (int)kibiBytes;
    }

    public DataFileMeta remoteFile() {
        return this.remoteFile;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        FileIOUtils.deleteFileOrDirectory(this.localFile);
    }
}

