/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.compact.CompactUnit;
import org.apache.paimon.mergetree.LevelSortedRun;
import org.apache.paimon.options.MemorySize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullCompactTrigger {
    private static final Logger LOG = LoggerFactory.getLogger(FullCompactTrigger.class);
    @Nullable
    private final Long fullCompactionInterval;
    @Nullable
    private final Long totalSizeThreshold;
    @Nullable
    private Long lastFullCompaction;

    public FullCompactTrigger(@Nullable Long fullCompactionInterval, @Nullable Long totalSizeThreshold) {
        this.fullCompactionInterval = fullCompactionInterval;
        this.totalSizeThreshold = totalSizeThreshold;
    }

    @Nullable
    public static FullCompactTrigger create(CoreOptions options) {
        Duration interval = options.optimizedCompactionInterval();
        MemorySize threshold = options.compactionTotalSizeThreshold();
        if (interval == null && threshold == null) {
            return null;
        }
        return new FullCompactTrigger(interval == null ? null : Long.valueOf(interval.toMillis()), threshold == null ? null : Long.valueOf(threshold.getBytes()));
    }

    public Optional<CompactUnit> tryFullCompact(int numLevels, List<LevelSortedRun> runs) {
        if (runs.size() == 1) {
            return Optional.empty();
        }
        int maxLevel = numLevels - 1;
        if (this.fullCompactionInterval != null && (this.lastFullCompaction == null || this.currentTimeMillis() - this.lastFullCompaction > this.fullCompactionInterval)) {
            LOG.debug("Universal compaction due to full compaction interval");
            this.updateLastFullCompaction();
            return Optional.of(CompactUnit.fromLevelRuns(maxLevel, runs));
        }
        if (this.totalSizeThreshold != null) {
            long totalSize = 0L;
            for (LevelSortedRun run : runs) {
                totalSize += run.run().totalSize();
            }
            if (totalSize < this.totalSizeThreshold) {
                return Optional.of(CompactUnit.fromLevelRuns(maxLevel, runs));
            }
        }
        return Optional.empty();
    }

    public void updateLastFullCompaction() {
        this.lastFullCompaction = this.currentTimeMillis();
    }

    @VisibleForTesting
    long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

