/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.options;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.FallbackKey;
import org.apache.paimon.options.OptionsUtils;

@Public
@ThreadSafe
public class Options
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final HashMap<String, String> data = new HashMap();

    public Options() {
    }

    public Options(Map<String, String> map) {
        this();
        map.forEach(this::setString);
    }

    public Options(Map<String, String> map1, Map<String, String> map2) {
        this();
        map1.forEach(this::setString);
        map2.forEach(this::setString);
    }

    public Options(Iterable<Map.Entry<String, String>> map) {
        this();
        map.forEach(entry -> this.setString((String)entry.getKey(), (String)entry.getValue()));
    }

    public static Options fromMap(Map<String, String> map) {
        return new Options(map);
    }

    public synchronized void setString(String key, String value) {
        this.data.put(key, value);
    }

    public synchronized void set(String key, String value) {
        this.data.put(key, value);
    }

    public synchronized <T> Options set(ConfigOption<T> option, T value) {
        boolean canBePrefixMap = OptionsUtils.canBePrefixMap(option);
        this.setValueInternal(option.key(), value, canBePrefixMap);
        return this;
    }

    public synchronized <T> T get(ConfigOption<T> option) {
        return (T)this.getOptional(option).orElseGet(option::defaultValue);
    }

    public synchronized String get(String key) {
        return this.data.get(key);
    }

    public synchronized <T> Optional<T> getOptional(ConfigOption<T> option) {
        Optional<Object> rawValue = this.getRawValueFromOption(option);
        Class<?> clazz = option.getClazz();
        try {
            return rawValue.map(v -> OptionsUtils.convertValue(v, clazz));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not parse value '%s' for key '%s'.", rawValue.map(Object::toString).orElse(""), option.key()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean contains(ConfigOption<?> configOption) {
        HashMap<String, String> hashMap = this.data;
        synchronized (hashMap) {
            BiFunction applier = (key, canBePrefixMap) -> {
                if (canBePrefixMap.booleanValue() && OptionsUtils.containsPrefixMap(this.data, key) || this.data.containsKey(key)) {
                    return Optional.of(true);
                }
                return Optional.empty();
            };
            return this.applyWithOption(configOption, applier).orElse(false);
        }
    }

    public synchronized Set<String> keySet() {
        return this.data.keySet();
    }

    public synchronized Map<String, String> toMap() {
        return this.data;
    }

    public synchronized Options removePrefix(String prefix) {
        return new Options(OptionsUtils.convertToPropertiesPrefixKey(this.data, prefix));
    }

    public synchronized String remove(String key) {
        return this.data.remove(key);
    }

    public synchronized void remove(ConfigOption<?> option) {
        this.data.remove(option.key());
    }

    public synchronized boolean containsKey(String key) {
        return this.data.containsKey(key);
    }

    public synchronized void addAllToProperties(Properties props) {
        props.putAll((Map<?, ?>)this.data);
    }

    public synchronized String getString(ConfigOption<String> option) {
        return this.get(option);
    }

    public synchronized boolean getBoolean(String key, boolean defaultValue) {
        return this.getRawValue(key).map(OptionsUtils::convertToBoolean).orElse(defaultValue);
    }

    public synchronized int getInteger(String key, int defaultValue) {
        return this.getRawValue(key).map(OptionsUtils::convertToInt).orElse(defaultValue);
    }

    public synchronized double getDouble(String key, double defaultValue) {
        return this.getRawValue(key).map(OptionsUtils::convertToDouble).orElse(defaultValue);
    }

    public synchronized String getString(String key, String defaultValue) {
        return this.getRawValue(key).map(OptionsUtils::convertToString).orElse(defaultValue);
    }

    public synchronized void setInteger(String key, int value) {
        this.setValueInternal(key, value);
    }

    public synchronized long getLong(String key, long defaultValue) {
        return this.getRawValue(key).map(OptionsUtils::convertToLong).orElse(defaultValue);
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Options options = (Options)o;
        return Objects.equals(this.data, options.data);
    }

    public synchronized int hashCode() {
        return Objects.hash(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void setValueInternal(String key, T value, boolean canBePrefixMap) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        if (value == null) {
            throw new NullPointerException("Value must not be null.");
        }
        HashMap<String, String> hashMap = this.data;
        synchronized (hashMap) {
            if (canBePrefixMap) {
                OptionsUtils.removePrefixMap(this.data, key);
            }
            this.data.put(key, OptionsUtils.convertToString(value));
        }
    }

    private Optional<Object> getRawValueFromOption(ConfigOption<?> configOption) {
        return this.applyWithOption(configOption, this::getRawValue);
    }

    private Optional<Object> getRawValue(String key) {
        return this.getRawValue(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Object> getRawValue(String key, boolean canBePrefixMap) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        HashMap<String, String> hashMap = this.data;
        synchronized (hashMap) {
            String valueFromExactKey = this.data.get(key);
            if (!canBePrefixMap || valueFromExactKey != null) {
                return Optional.ofNullable(valueFromExactKey);
            }
            Map<String, String> valueFromPrefixMap = OptionsUtils.convertToPropertiesPrefixed(this.data, key);
            if (valueFromPrefixMap.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(valueFromPrefixMap);
        }
    }

    private <T> Optional<T> applyWithOption(ConfigOption<?> option, BiFunction<String, Boolean, Optional<T>> applier) {
        boolean canBePrefixMap = OptionsUtils.canBePrefixMap(option);
        Optional<T> valueFromExactKey = applier.apply(option.key(), canBePrefixMap);
        if (valueFromExactKey.isPresent()) {
            return valueFromExactKey;
        }
        if (option.hasFallbackKeys()) {
            for (FallbackKey fallbackKey : option.fallbackKeys()) {
                Optional<T> valueFromFallbackKey = applier.apply(fallbackKey.getKey(), canBePrefixMap);
                if (!valueFromFallbackKey.isPresent()) continue;
                return valueFromFallbackKey;
            }
        }
        return Optional.empty();
    }

    private <T> void setValueInternal(String key, T value) {
        this.setValueInternal(key, value, false);
    }
}

