/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition;

import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.partition.PartitionExpireStrategy;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.partition.PartitionTimeExtractor;
import org.apache.paimon.types.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionValuesTimeExpireStrategy
extends PartitionExpireStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionValuesTimeExpireStrategy.class);
    private final PartitionTimeExtractor timeExtractor;

    public PartitionValuesTimeExpireStrategy(CoreOptions options, RowType partitionType) {
        super(partitionType, options.partitionDefaultName());
        String timePattern = options.partitionTimestampPattern();
        String timeFormatter = options.partitionTimestampFormatter();
        this.timeExtractor = new PartitionTimeExtractor(timePattern, timeFormatter);
    }

    @Override
    public List<PartitionEntry> selectExpiredPartitions(FileStoreScan scan, LocalDateTime expirationTime) {
        return scan.withPartitionFilter(new PartitionValuesTimePredicate(expirationTime)).readPartitionEntries();
    }

    public boolean isExpired(LocalDateTime expireDateTime, BinaryRow partition) {
        return new PartitionValuesTimePredicate(expireDateTime).test(partition);
    }

    private class PartitionValuesTimePredicate
    implements PartitionPredicate {
        private final LocalDateTime expireDateTime;

        private PartitionValuesTimePredicate(LocalDateTime expireDateTime) {
            this.expireDateTime = expireDateTime;
        }

        @Override
        public boolean test(BinaryRow partition) {
            Object[] array = PartitionValuesTimeExpireStrategy.this.convertPartition(partition);
            try {
                LocalDateTime partTime = PartitionValuesTimeExpireStrategy.this.timeExtractor.extract(PartitionValuesTimeExpireStrategy.this.partitionKeys, Arrays.asList(array));
                return this.expireDateTime.isAfter(partTime);
            }
            catch (DateTimeParseException e) {
                LOG.warn("Can't extract datetime from partition {}. If you want to configure partition expiration, please:\n  1. Check the expiration configuration.\n  2. Manually delete the partition using the drop-partition command if the partition value is non-date formatted.\n  3. Use '{}' expiration strategy by set '{}', which supports non-date formatted partition.", new Object[]{this.formatPartitionInfo(array), CoreOptions.PartitionExpireStrategy.UPDATE_TIME, CoreOptions.PARTITION_EXPIRATION_STRATEGY.key()});
                return false;
            }
            catch (NullPointerException e) {
                LOG.warn("This partition {} cannot be expired because it contains null value. You can try to drop it manually or use '{}' expiration strategy by set '{}'.", new Object[]{this.formatPartitionInfo(array), CoreOptions.PartitionExpireStrategy.UPDATE_TIME, CoreOptions.PARTITION_EXPIRATION_STRATEGY.key()});
                return false;
            }
        }

        private String formatPartitionInfo(Object[] array) {
            return IntStream.range(0, PartitionValuesTimeExpireStrategy.this.partitionKeys.size()).mapToObj(i -> (String)PartitionValuesTimeExpireStrategy.this.partitionKeys.get(i) + ":" + array[i]).collect(Collectors.joining(","));
        }

        @Override
        public boolean test(long rowCount, InternalRow minValues, InternalRow maxValues, InternalArray nullCounts) {
            return true;
        }
    }
}

