/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.reader;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.Filter;

public interface FileRecordIterator<T>
extends RecordReader.RecordIterator<T> {
    public long returnedPosition();

    public Path filePath();

    @Override
    default public <R> FileRecordIterator<R> transform(final Function<T, R> function) {
        final FileRecordIterator thisIterator = this;
        return new FileRecordIterator<R>(){

            @Override
            public long returnedPosition() {
                return thisIterator.returnedPosition();
            }

            @Override
            public Path filePath() {
                return thisIterator.filePath();
            }

            @Override
            @Nullable
            public R next() throws IOException {
                Object next = thisIterator.next();
                if (next == null) {
                    return null;
                }
                return function.apply(next);
            }

            @Override
            public void releaseBatch() {
                thisIterator.releaseBatch();
            }
        };
    }

    @Override
    default public FileRecordIterator<T> filter(final Filter<T> filter) {
        final FileRecordIterator thisIterator = this;
        return new FileRecordIterator<T>(){

            @Override
            public long returnedPosition() {
                return thisIterator.returnedPosition();
            }

            @Override
            public Path filePath() {
                return thisIterator.filePath();
            }

            @Override
            @Nullable
            public T next() throws IOException {
                Object next;
                do {
                    if ((next = thisIterator.next()) != null) continue;
                    return null;
                } while (!filter.test(next));
                return next;
            }

            @Override
            public void releaseBatch() {
                thisIterator.releaseBatch();
            }
        };
    }
}

