/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.operation.SplitRead;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.TopN;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.AbstractDataTableRead;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.splitread.SplitReadConfig;
import org.apache.paimon.table.source.splitread.SplitReadProvider;
import org.apache.paimon.types.RowType;

public final class AppendTableRead
extends AbstractDataTableRead {
    private final List<SplitReadProvider> readProviders;
    @Nullable
    private RowType readType = null;
    private Predicate predicate = null;
    private TopN topN = null;
    private Integer limit = null;

    public AppendTableRead(List<Function<SplitReadConfig, SplitReadProvider>> providerFactories, TableSchema schema) {
        super(schema);
        this.readProviders = providerFactories.stream().map(factory -> (SplitReadProvider)factory.apply(this::config)).collect(Collectors.toList());
    }

    private List<SplitRead<InternalRow>> initialized() {
        ArrayList<SplitRead<InternalRow>> readers = new ArrayList<SplitRead<InternalRow>>();
        for (SplitReadProvider readProvider : this.readProviders) {
            if (!readProvider.get().initialized()) continue;
            readers.add(readProvider.get().get());
        }
        return readers;
    }

    private void config(SplitRead<InternalRow> read) {
        if (this.readType != null) {
            read = read.withReadType(this.readType);
        }
        read.withFilter(this.predicate);
        read.withTopN(this.topN);
        read.withLimit(this.limit);
    }

    @Override
    public void applyReadType(RowType readType) {
        this.initialized().forEach(r -> r.withReadType(readType));
        this.readType = readType;
    }

    @Override
    protected InnerTableRead innerWithFilter(Predicate predicate) {
        this.initialized().forEach(r -> r.withFilter(predicate));
        this.predicate = predicate;
        return this;
    }

    @Override
    public InnerTableRead withTopN(TopN topN) {
        this.initialized().forEach(r -> r.withTopN(topN));
        this.topN = topN;
        return this;
    }

    @Override
    public InnerTableRead withLimit(int limit) {
        this.initialized().forEach(r -> r.withLimit(limit));
        this.limit = limit;
        return this;
    }

    @Override
    public RecordReader<InternalRow> reader(Split split) throws IOException {
        DataSplit dataSplit = (DataSplit)split;
        for (SplitReadProvider readProvider : this.readProviders) {
            if (!readProvider.match(dataSplit, false)) continue;
            return readProvider.get().get().createReader(dataSplit);
        }
        throw new RuntimeException("Should not happen.");
    }
}

