/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.paimon.flink.action.cdc.CdcActionITCaseBase;
import org.apache.paimon.flink.action.cdc.mysql.MySqlContainer;
import org.apache.paimon.flink.action.cdc.mysql.MySqlSyncDatabaseAction;
import org.apache.paimon.flink.action.cdc.mysql.MySqlSyncTableAction;
import org.apache.paimon.flink.action.cdc.mysql.MySqlVersion;
import org.junit.jupiter.api.AfterAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startables;

public class MySqlActionITCaseBase
extends CdcActionITCaseBase {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlActionITCaseBase.class);
    protected static final MySqlContainer MYSQL_CONTAINER = MySqlActionITCaseBase.createMySqlContainer(MySqlVersion.V5_7);
    private static final String USER = "paimonuser";
    private static final String PASSWORD = "paimonpw";

    @AfterAll
    public static void stopContainers() {
        LOG.info("Stopping containers...");
        MYSQL_CONTAINER.stop();
        LOG.info("Containers are stopped.");
    }

    private static MySqlContainer createMySqlContainer(MySqlVersion version) {
        return (MySqlContainer)new MySqlContainer(version).withConfigurationOverride("mysql/my.cnf").withUsername(USER).withPassword(PASSWORD).withEnv("TZ", "America/Los_Angeles").withLogConsumer((Consumer)new Slf4jLogConsumer(LOG));
    }

    protected static void start() {
        LOG.info("Starting containers...");
        Startables.deepStart(Stream.of(MYSQL_CONTAINER)).join();
        LOG.info("Containers are started.");
    }

    protected Statement getStatement() throws SQLException {
        Connection conn = DriverManager.getConnection(MYSQL_CONTAINER.getJdbcUrl(), MYSQL_CONTAINER.getUsername(), MYSQL_CONTAINER.getPassword());
        return conn.createStatement();
    }

    protected Map<String, String> getBasicMySqlConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("hostname", MYSQL_CONTAINER.getHost());
        config.put("port", String.valueOf(MYSQL_CONTAINER.getDatabasePort()));
        config.put("username", USER);
        config.put("password", PASSWORD);
        config.put("server-time-zone", ZoneId.of("America/New_York").toString());
        return config;
    }

    protected MySqlSyncTableActionBuilder syncTableActionBuilder(Map<String, String> mySqlConfig) {
        return new MySqlSyncTableActionBuilder(mySqlConfig);
    }

    protected MySqlSyncDatabaseActionBuilder syncDatabaseActionBuilder(Map<String, String> mySqlConfig) {
        return new MySqlSyncDatabaseActionBuilder(mySqlConfig);
    }

    protected class MySqlSyncDatabaseActionBuilder
    extends CdcActionITCaseBase.SyncDatabaseActionBuilder<MySqlSyncDatabaseAction> {
        public MySqlSyncDatabaseActionBuilder(Map<String, String> mySqlConfig) {
            super(mySqlConfig);
        }

        @Override
        public MySqlSyncDatabaseAction build() {
            ArrayList<String> args = new ArrayList<String>(Arrays.asList("mysql_sync_database", "--warehouse", MySqlActionITCaseBase.this.warehouse, "--database", MySqlActionITCaseBase.this.database));
            args.addAll(MySqlActionITCaseBase.this.mapToArgs("--mysql-conf", this.sourceConfig));
            args.addAll(MySqlActionITCaseBase.this.mapToArgs("--catalog-conf", this.catalogConfig));
            args.addAll(MySqlActionITCaseBase.this.mapToArgs("--table-conf", this.tableConfig));
            args.addAll(MySqlActionITCaseBase.this.nullableToArgs("--ignore-incompatible", this.ignoreIncompatible));
            args.addAll(MySqlActionITCaseBase.this.nullableToArgs("--merge-shards", this.mergeShards));
            args.addAll(MySqlActionITCaseBase.this.nullableToArgs("--table-prefix", this.tablePrefix));
            args.addAll(MySqlActionITCaseBase.this.nullableToArgs("--table-suffix", this.tableSuffix));
            args.addAll(MySqlActionITCaseBase.this.nullableToArgs("--including-tables", this.includingTables));
            args.addAll(MySqlActionITCaseBase.this.nullableToArgs("--excluding-tables", this.excludingTables));
            args.addAll(MySqlActionITCaseBase.this.nullableToArgs("--mode", this.mode));
            args.addAll(MySqlActionITCaseBase.this.listToArgs("--type-mapping", this.typeMappingModes));
            args.addAll(MySqlActionITCaseBase.this.listToArgs("--metadata-column", this.metadataColumn));
            return (MySqlSyncDatabaseAction)MySqlActionITCaseBase.this.createAction(MySqlSyncDatabaseAction.class, args);
        }
    }

    protected class MySqlSyncTableActionBuilder
    extends CdcActionITCaseBase.SyncTableActionBuilder<MySqlSyncTableAction> {
        public MySqlSyncTableActionBuilder(Map<String, String> mySqlConfig) {
            super(mySqlConfig);
        }

        @Override
        public MySqlSyncTableAction build() {
            ArrayList<String> args = new ArrayList<String>(Arrays.asList("mysql_sync_table", "--warehouse", MySqlActionITCaseBase.this.warehouse, "--database", MySqlActionITCaseBase.this.database, "--table", MySqlActionITCaseBase.this.tableName));
            args.addAll(MySqlActionITCaseBase.this.mapToArgs("--mysql-conf", this.sourceConfig));
            args.addAll(MySqlActionITCaseBase.this.mapToArgs("--catalog-conf", this.catalogConfig));
            args.addAll(MySqlActionITCaseBase.this.mapToArgs("--table-conf", this.tableConfig));
            args.addAll(MySqlActionITCaseBase.this.listToArgs("--partition-keys", this.partitionKeys));
            args.addAll(MySqlActionITCaseBase.this.listToArgs("--primary-keys", this.primaryKeys));
            args.addAll(MySqlActionITCaseBase.this.listToArgs("--type-mapping", this.typeMappingModes));
            args.addAll(MySqlActionITCaseBase.this.listToMultiArgs("--computed-column", this.computedColumnArgs));
            args.addAll(MySqlActionITCaseBase.this.listToMultiArgs("--metadata-column", this.metadataColumns));
            return (MySqlSyncTableAction)MySqlActionITCaseBase.this.createAction(MySqlSyncTableAction.class, args);
        }
    }
}

