/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.TestCdcEvent;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;

public class TestTable {
    private final RowType initialRowType;
    private final Queue<TestCdcEvent> events;
    private final Map<Integer, Map<String, String>> expected;

    public TestTable(String tableName, int numEvents, int numSchemaChanges, int numPartitions, int numKeys) {
        int i;
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<Boolean> isBigInt = new ArrayList<Boolean>();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int numFields = random.nextInt(5) + 1;
        DataType[] initialFieldTypes = new DataType[2 + numFields];
        initialFieldTypes[0] = DataTypes.INT();
        initialFieldTypes[1] = DataTypes.INT();
        String[] initialFieldNames = new String[2 + numFields];
        initialFieldNames[0] = "pt";
        initialFieldNames[1] = "k";
        for (int i2 = 0; i2 < numFields; ++i2) {
            fieldNames.add("v" + i2);
            initialFieldNames[2 + i2] = "v" + i2;
            if (random.nextBoolean()) {
                isBigInt.add(true);
                initialFieldTypes[2 + i2] = DataTypes.BIGINT();
                continue;
            }
            isBigInt.add(false);
            initialFieldTypes[2 + i2] = DataTypes.INT();
        }
        this.initialRowType = RowType.of((DataType[])initialFieldTypes, (String[])initialFieldNames);
        HashSet<Integer> schemaChangePositions = new HashSet<Integer>();
        numSchemaChanges = Math.min(numSchemaChanges, numEvents / 2);
        for (i = 0; i < numSchemaChanges; ++i) {
            int pos;
            while (schemaChangePositions.contains(pos = random.nextInt(numEvents))) {
            }
            schemaChangePositions.add(pos);
        }
        this.events = new LinkedList<TestCdcEvent>();
        this.expected = new HashMap<Integer, Map<String, String>>();
        for (i = 0; i < numEvents; ++i) {
            if (schemaChangePositions.contains(i)) {
                if (random.nextBoolean()) {
                    int idx = random.nextInt(fieldNames.size());
                    isBigInt.set(idx, true);
                } else {
                    String newName = "v" + fieldNames.size();
                    fieldNames.add(newName);
                    isBigInt.add(false);
                }
                this.events.add(new TestCdcEvent(tableName, this.currentDataFieldList(fieldNames, isBigInt)));
                continue;
            }
            HashMap<String, String> fields = new HashMap<String, String>();
            int key = random.nextInt(numKeys);
            fields.put("k", String.valueOf(key));
            int pt = key % numPartitions;
            fields.put("pt", String.valueOf(pt));
            for (int j = 0; j < fieldNames.size(); ++j) {
                String fieldName = (String)fieldNames.get(j);
                if (((Boolean)isBigInt.get(j)).booleanValue()) {
                    fields.put(fieldName, String.valueOf(random.nextLong()));
                    continue;
                }
                fields.put(fieldName, String.valueOf(random.nextInt()));
            }
            ArrayList<CdcRecord> records = new ArrayList<CdcRecord>();
            boolean shouldInsert = true;
            if (this.expected.containsKey(key)) {
                records.add(new CdcRecord(RowKind.DELETE, this.expected.get(key)));
                this.expected.remove(key);
                boolean bl = shouldInsert = random.nextInt(5) > 0;
            }
            if (shouldInsert) {
                records.add(new CdcRecord(RowKind.INSERT, fields));
                this.expected.put(key, fields);
            }
            this.events.add(new TestCdcEvent(tableName, records, Objects.hash(tableName, key)));
        }
    }

    private List<DataField> currentDataFieldList(List<String> fieldNames, List<Boolean> isBigInt) {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add((DataField)this.initialRowType.getFields().get(0));
        fields.add((DataField)this.initialRowType.getFields().get(1));
        for (int i = 0; i < fieldNames.size(); ++i) {
            fields.add(new DataField(2 + i, fieldNames.get(i), (DataType)(isBigInt.get(i) != false ? DataTypes.BIGINT() : DataTypes.INT())));
        }
        return fields;
    }

    public RowType initialRowType() {
        return this.initialRowType;
    }

    public Queue<TestCdcEvent> events() {
        return this.events;
    }

    public void assertResult(TableSchema schema, Iterator<InternalRow> it) {
        HashMap actual = new HashMap();
        while (it.hasNext()) {
            InternalRow row = it.next();
            HashMap fields = new HashMap();
            for (int i = 0; i < schema.fieldNames().size(); ++i) {
                if (row.isNullAt(i)) continue;
                fields.put(schema.fieldNames().get(i), String.valueOf(((DataField)schema.fields().get(i)).type().equals((Object)DataTypes.BIGINT()) ? row.getLong(i) : (long)row.getInt(i)));
            }
            actual.put(Integer.valueOf((String)fields.get("k")), fields);
        }
        Assertions.assertThat(actual).isEqualTo(this.expected);
    }
}

