/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql;

import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.paimon.flink.action.ActionBase;
import org.apache.paimon.flink.action.MultiTablesSinkMode;
import org.apache.paimon.flink.action.cdc.mysql.MySqlActionITCaseBase;
import org.apache.paimon.flink.action.cdc.mysql.MySqlSyncDatabaseAction;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MySqlSyncDatabaseTableListITCase
extends MySqlActionITCaseBase {
    @BeforeAll
    public static void startContainers() {
        MYSQL_CONTAINER.withSetupSQL("mysql/tablelist_test_setup.sql");
        MySqlSyncDatabaseTableListITCase.start();
    }

    @Test
    @Timeout(value=120L)
    public void testActionRunResult() throws Exception {
        Map<String, String> mySqlConfig = this.getBasicMySqlConfig();
        mySqlConfig.put("database-name", ThreadLocalRandom.current().nextBoolean() ? ".*shard_.*" : "shard_1|shard_2|shard_3|x_shard_1");
        MultiTablesSinkMode mode = ThreadLocalRandom.current().nextBoolean() ? MultiTablesSinkMode.DIVIDED : MultiTablesSinkMode.COMBINED;
        MySqlSyncDatabaseAction action = (MySqlSyncDatabaseAction)this.syncDatabaseActionBuilder(mySqlConfig).withTableConfig(this.getBasicTableConfig()).mergeShards(false).withMode(mode.configString()).includingTables("t.+|s.+").excludingTables("ta|sa").build();
        this.runActionWithDefaultEnv((ActionBase)action);
        this.assertExactlyExistTables("shard_1_t11", "shard_1_t2", "shard_1_t3", "shard_1_taa", "shard_1_s2", "shard_2_t1", "shard_2_t22", "shard_2_t3", "shard_2_tb", "x_shard_1_t1");
        if (mode == MultiTablesSinkMode.COMBINED) {
            try (Statement statement = this.getStatement();){
                this.waitForResult(Collections.singletonList("+I[1, A]"), this.getFileStoreTable("shard_1_t2"), RowType.of((DataType[])new DataType[]{DataTypes.INT().notNull(), DataTypes.VARCHAR((int)100)}, (String[])new String[]{"k", "name"}), Collections.singletonList("k"));
                statement.executeUpdate("USE shard_2");
                statement.executeUpdate("CREATE TABLE ta (k INT, name VARCHAR(100), PRIMARY KEY (k))");
                statement.executeUpdate("CREATE TABLE s3 (k INT, name VARCHAR(100), PRIMARY KEY (k))");
                statement.executeUpdate("CREATE DATABASE shard_3");
                statement.executeUpdate("USE shard_3");
                statement.executeUpdate("CREATE TABLE ta (k INT, name VARCHAR(100), PRIMARY KEY (k))");
                statement.executeUpdate("CREATE TABLE m (k INT, name VARCHAR(100), PRIMARY KEY (k))");
                statement.executeUpdate("CREATE TABLE tab (k INT, name VARCHAR(100), PRIMARY KEY (k))");
                statement.executeUpdate("CREATE DATABASE what");
                statement.executeUpdate("USE what");
                statement.executeUpdate("CREATE TABLE ta (k INT, name VARCHAR(100), PRIMARY KEY (k))");
                statement.executeUpdate("CREATE TABLE s4 (k INT, name VARCHAR(100), PRIMARY KEY (k))");
                this.waitingTables("shard_2_s3", "shard_3_tab");
            }
        }
    }
}

