/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.pulsar;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.flink.action.cdc.MessageQueueSchemaUtils;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.format.DataFormat;
import org.apache.paimon.flink.action.cdc.pulsar.PulsarActionITCaseBase;
import org.apache.paimon.flink.action.cdc.pulsar.PulsarActionUtils;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class PulsarSchemaITCase
extends PulsarActionITCaseBase {
    @Test
    @Timeout(value=60L)
    public void testPulsarSchema() throws Exception {
        String topic = "test_pulsar_schema";
        this.createTopic(topic);
        List<String> messages = this.getMessages("kafka/canal/table/schemaevolution/canal-data-1.txt");
        this.sendMessages(topic, messages);
        Configuration pulsarConfig = Configuration.fromMap(this.getBasicPulsarConfig());
        pulsarConfig.setString(PulsarActionUtils.TOPIC.key(), topic);
        pulsarConfig.set(PulsarActionUtils.VALUE_FORMAT, (Object)"canal-json");
        Schema pulsarSchema = MessageQueueSchemaUtils.getSchema((MessageQueueSchemaUtils.ConsumerWrapper)PulsarActionUtils.createPulsarConsumer((Configuration)pulsarConfig), (DataFormat)PulsarActionUtils.getDataFormat((Configuration)pulsarConfig), (TypeMapping)TypeMapping.defaultMapping());
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "pt", (DataType)DataTypes.INT()));
        fields.add(new DataField(1, "_id", DataTypes.INT().notNull()));
        fields.add(new DataField(2, "v1", (DataType)DataTypes.VARCHAR((int)10)));
        Assertions.assertThat((List)pulsarSchema.fields()).isEqualTo(fields);
    }
}

