/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.flink.action.cdc.SyncTableActionBase;
import org.apache.paimon.flink.action.cdc.SynchronizationActionFactoryBase;
import org.apache.paimon.flink.action.cdc.TypeMapping;

public abstract class SyncTableActionFactoryBase
extends SynchronizationActionFactoryBase<SyncTableActionBase> {
    protected String database;
    protected String table;

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        this.database = params.getRequired("database");
        this.table = params.getRequired("table");
        return super.create(params);
    }

    @Override
    protected void withParams(MultipleParameterToolAdapter params, SyncTableActionBase action) {
        if (params.has("partition_keys")) {
            action.withPartitionKeys(params.get("partition_keys").split(","));
        }
        if (params.has("primary_keys")) {
            action.withPrimaryKeys(params.get("primary_keys").split(","));
        }
        if (params.has("computed_column")) {
            action.withComputedColumnArgs(new ArrayList<String>(params.getMultiParameter("computed_column")));
        }
        if (params.has("metadata_column")) {
            ArrayList<String> metadataColumns = new ArrayList<String>(params.getMultiParameter("metadata_column"));
            if (metadataColumns.size() == 1) {
                action.withMetadataColumns(Arrays.asList(((String)metadataColumns.get(0)).split(",")));
            } else {
                action.withMetadataColumns(metadataColumns);
            }
        }
        if (params.has("type_mapping")) {
            String[] options = params.get("type_mapping").split(",");
            action.withTypeMapping(TypeMapping.parse(options));
        }
    }
}

