/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.annotation.Experimental;
import org.apache.paimon.types.RowKind;

@Experimental
public class CdcRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RowKind kind;
    private final Map<String, String> data;

    public CdcRecord(RowKind kind, Map<String, String> data) {
        this.kind = kind;
        this.data = data;
    }

    public static CdcRecord emptyRecord() {
        return new CdcRecord(RowKind.INSERT, Collections.emptyMap());
    }

    public RowKind kind() {
        return this.kind;
    }

    public Map<String, String> data() {
        return this.data;
    }

    public CdcRecord fieldNameLowerCase() {
        HashMap<String, String> newData = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            newData.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return new CdcRecord(this.kind, newData);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CdcRecord)) {
            return false;
        }
        CdcRecord that = (CdcRecord)o;
        return Objects.equals(this.kind, that.kind) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.data);
    }

    public String toString() {
        return this.kind.shortString() + " " + this.data;
    }
}

